/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.validate.UsernameTokenValidator;

public class OpenEJBLoginValidator
extends UsernameTokenValidator {
    protected void verifyDigestPassword(UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        super.verifyDigestPassword(usernameToken, data);
        WSPasswordCallback pwCb = new WSPasswordCallback(usernameToken.getName(), null, usernameToken.getPasswordType(), 2, data);
        try {
            data.getCallbackHandler().handle(new Callback[]{pwCb});
        }
        catch (Exception exception) {
            // empty catch block
        }
        String user = usernameToken.getName();
        String password = pwCb.getPassword();
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        try {
            securityService.disassociate();
            Object token = securityService.login(user, password);
            if (AbstractSecurityService.class.isInstance(securityService) && ((AbstractSecurityService)AbstractSecurityService.class.cast(securityService)).currentState() == null) {
                securityService.associate(token);
            }
        }
        catch (LoginException e) {
            throw new SecurityException("cannot log user " + user, e);
        }
    }
}

