/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class BusDefinitionParser
extends AbstractBeanDefinitionParser {
    private static AtomicInteger counter = new AtomicInteger(0);

    public BusDefinitionParser() {
        this.setBeanClass(BusConfig.class);
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String id;
        String bus = element.getAttribute("bus");
        if (StringUtils.isEmpty((String)bus) && StringUtils.isEmpty((String)(bus = element.getAttribute("name")))) {
            element.setAttribute("bus", bus);
        }
        element.removeAttribute("name");
        if (StringUtils.isEmpty((String)bus)) {
            bus = "cxf";
        }
        if (!StringUtils.isEmpty((String)(id = element.getAttribute("id")))) {
            bean.addPropertyValue("id", (Object)id);
        }
        super.doParse(element, ctx, bean);
        if (ctx.getRegistry().containsBeanDefinition(bus)) {
            BeanDefinition def = ctx.getRegistry().getBeanDefinition(bus);
            this.copyProps(bean, def);
            bean.addConstructorArgValue((Object)bus);
        } else if (!"cxf".equals(bus)) {
            bean.getRawBeanDefinition().setBeanClass(SpringBus.class);
            bean.setDestroyMethodName("shutdown");
            try {
                element.setUserData("ID", bus, null);
                bean.getRawBeanDefinition().getPropertyValues().removePropertyValue("bus");
            }
            catch (Throwable throwable) {}
        } else {
            this.addBusWiringAttribute(bean, BusWiringType.PROPERTY, bus, ctx);
            bean.getRawBeanDefinition().setAttribute(WIRE_BUS_CREATE, (Object)this.resolveId(element, null, ctx));
            bean.addConstructorArgValue((Object)bus);
        }
    }

    protected boolean processBusAttribute(Element element, ParserContext ctx, BeanDefinitionBuilder bean, String val) {
        return false;
    }

    private void copyProps(BeanDefinitionBuilder src, BeanDefinition def) {
        for (PropertyValue v : src.getBeanDefinition().getPropertyValues().getPropertyValues()) {
            if (!"bus".equals(v.getName())) {
                def.getPropertyValues().addPropertyValue(v.getName(), v.getValue());
            }
            src.getBeanDefinition().getPropertyValues().removePropertyValue(v);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element e, String name) {
        if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name)) {
            List list = ctx.getDelegate().parseListElement(e, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("properties".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(e, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue("properties", (Object)map);
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext ctx) {
        String bus = null;
        try {
            bus = (String)element.getUserData("ID");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bus == null) {
            bus = element.getAttribute("bus");
            if (StringUtils.isEmpty((String)bus)) {
                bus = element.getAttribute("name");
            }
            bus = StringUtils.isEmpty((String)bus) ? "cxf.config" + counter.getAndIncrement() : bus + ".config";
            try {
                element.setUserData("ID", bus, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NoJSR250Annotations
    public static class BusConfig
    extends AbstractBasicInterceptorProvider
    implements ApplicationContextAware {
        CXFBusImpl bus;
        String busName;
        String id;
        Collection<AbstractFeature> features;
        Map<String, Object> properties;

        public BusConfig(String busName) {
            this.busName = busName;
        }

        public void setBus(Bus bb) {
            if (this.bus == bb) {
                return;
            }
            CXFBusImpl b = (CXFBusImpl)bb;
            if (this.properties != null) {
                b.setProperties(this.properties);
                this.properties = null;
            }
            if (!this.getInInterceptors().isEmpty()) {
                b.getInInterceptors().addAll(this.getInInterceptors());
            }
            if (!this.getOutInterceptors().isEmpty()) {
                b.getOutInterceptors().addAll(this.getOutInterceptors());
            }
            if (!this.getInFaultInterceptors().isEmpty()) {
                b.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
            }
            if (!this.getOutFaultInterceptors().isEmpty()) {
                b.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
            }
            if (!StringUtils.isEmpty((String)this.id)) {
                b.setId(this.id);
            }
            if (this.features != null) {
                b.setFeatures(this.features);
                this.features = null;
            }
            this.bus = b;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            if (this.bus != null) {
                return;
            }
        }

        public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
            if (this.bus != null) {
                return this.bus.getOutFaultInterceptors();
            }
            return super.getOutFaultInterceptors();
        }

        public List<Interceptor<? extends Message>> getInFaultInterceptors() {
            if (this.bus != null) {
                return this.bus.getInFaultInterceptors();
            }
            return super.getInFaultInterceptors();
        }

        public List<Interceptor<? extends Message>> getInInterceptors() {
            if (this.bus != null) {
                return this.bus.getInInterceptors();
            }
            return super.getInInterceptors();
        }

        public List<Interceptor<? extends Message>> getOutInterceptors() {
            if (this.bus != null) {
                return this.bus.getOutInterceptors();
            }
            return super.getOutInterceptors();
        }

        public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.getInInterceptors().addAll(interceptors);
            } else {
                super.setInInterceptors(interceptors);
            }
        }

        public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.getInFaultInterceptors().addAll(interceptors);
            } else {
                super.setInFaultInterceptors(interceptors);
            }
        }

        public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.getOutInterceptors().addAll(interceptors);
            } else {
                super.setOutInterceptors(interceptors);
            }
        }

        public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.setOutFaultInterceptors(interceptors);
            } else {
                super.setOutFaultInterceptors(interceptors);
            }
        }

        public Collection<AbstractFeature> getFeatures() {
            if (this.bus != null) {
                return this.bus.getFeatures();
            }
            return this.features;
        }

        public void setFeatures(Collection<AbstractFeature> features) {
            if (this.bus != null) {
                this.bus.setFeatures(features);
            } else {
                this.features = features;
            }
        }

        public Map<String, Object> getProperties() {
            if (this.bus != null) {
                return this.bus.getProperties();
            }
            return this.properties;
        }

        public void setProperties(Map<String, Object> s) {
            if (this.bus != null) {
                this.bus.setProperties(s);
            } else {
                this.properties = s;
            }
        }

        public void setId(String s) {
            this.id = s;
        }
    }
}

