/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd.util;

import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.FilterListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.ServletListener;

public final class HttpUtil {
    private static final String WILDCARD = SystemInstance.get().getProperty("openejb.http.wildcard", ".*");

    private HttpUtil() {
    }

    public static String selectSingleAddress(List<String> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return null;
        }
        for (String address : addresses) {
            if (!address.startsWith("http:")) continue;
            return address;
        }
        for (String address : addresses) {
            if (!address.startsWith("https:")) continue;
            return address;
        }
        return addresses.iterator().next();
    }

    public static boolean addServlet(String classname, WebContext wc, String mapping) {
        ServletListener listener;
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return false;
        }
        try {
            listener = new ServletListener((Servlet)wc.newInstance(wc.getClassLoader().loadClass(classname)), wc.getContextRoot());
            listener.getDelegate().init(null);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
        registry.addHttpListener(listener, HttpUtil.pattern(wc.getContextRoot(), mapping));
        return true;
    }

    public static void removeServlet(String mapping, WebContext wc) {
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return;
        }
        Servlet servlet = ((ServletListener)registry.removeHttpListener(HttpUtil.pattern(wc.getContextRoot(), mapping))).getDelegate();
        servlet.destroy();
        wc.destroy((Object)servlet);
    }

    public static boolean addFilter(String classname, WebContext wc, String mapping, FilterConfig config) {
        FilterListener listener;
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return false;
        }
        try {
            listener = new FilterListener((Filter)wc.newInstance(wc.getClassLoader().loadClass(classname)), wc.getContextRoot());
            listener.getDelegate().init(config);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
        registry.addHttpFilter(listener, HttpUtil.pattern(wc.getContextRoot(), mapping));
        return true;
    }

    public static void removeFilter(String mapping, WebContext wc) {
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return;
        }
        Collection<HttpListener> filters = registry.removeHttpFilter(HttpUtil.pattern(wc.getContextRoot(), mapping));
        for (HttpListener listener : filters) {
            Filter filter = ((FilterListener)listener).getDelegate();
            filter.destroy();
            wc.destroy((Object)filter);
        }
        filters.clear();
    }

    private static String pattern(String contextRoot, String mapping) {
        String path = "";
        if (contextRoot != null) {
            path = contextRoot;
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!mapping.startsWith("/") && !path.endsWith("/")) {
            path = path + '/';
        }
        if ((path = path + mapping).endsWith("*")) {
            path = path.substring(0, path.length()) + WILDCARD;
        }
        return path;
    }
}

