/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public class ResultPacker {
    private static final Localizer _loc = Localizer.forPackage(ResultPacker.class);
    private static final Set<Class<?>> _stdTypes = new HashSet();
    private final Class<?> _resultClass;
    private final String[] _aliases;
    private final Member[] _sets;
    private final Method _put;
    private final Constructor<?> _constructor;

    protected ResultPacker() {
        this._resultClass = null;
        this._aliases = null;
        this._sets = null;
        this._put = null;
        this._constructor = null;
    }

    public ResultPacker(Class<?> candidate, String alias, Class<?> resultClass) {
        this(candidate, null, new String[]{alias}, resultClass);
    }

    public ResultPacker(Class<?>[] types, String[] aliases, Class<?> resultClass) {
        this(null, types, aliases, resultClass);
    }

    private ResultPacker(Class<?> candidate, Class<?>[] types, String[] aliases, Class<?> resultClass) {
        this._aliases = aliases;
        if (candidate == resultClass || this.isInterface(resultClass, candidate) || types != null && types.length == 1 && types[0] == resultClass || resultClass.isArray()) {
            this._resultClass = resultClass;
            this._sets = null;
            this._put = null;
            this._constructor = null;
        } else if (resultClass.isPrimitive()) {
            this.assertConvertable(candidate, types, resultClass);
            this._resultClass = Filters.wrap(resultClass);
            this._sets = null;
            this._put = null;
            this._constructor = null;
        } else {
            this._resultClass = resultClass;
            if (!_stdTypes.contains(this._resultClass)) {
                Constructor<?> cons = null;
                if (types != null && types.length > 0) {
                    try {
                        cons = this._resultClass.getConstructor(types);
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
                this._constructor = cons;
                if (cons == null) {
                    Method[] methods = this._resultClass.getMethods();
                    Field[] fields = this._resultClass.getFields();
                    this._put = ResultPacker.findPut(methods);
                    this._sets = new Member[aliases.length];
                    for (int i = 0; i < this._sets.length; ++i) {
                        Class<?> type = types == null ? candidate : types[i];
                        this._sets[i] = ResultPacker.findSet(aliases[i], type, fields, methods);
                        if (this._sets[i] != null || this._put != null) continue;
                        throw new UserException(_loc.get("cant-set", resultClass, aliases[i], types == null ? null : Arrays.asList(types)));
                    }
                } else {
                    this._sets = null;
                    this._put = null;
                }
            } else {
                if (resultClass != Map.class && resultClass != HashMap.class && resultClass != Object[].class) {
                    this.assertConvertable(candidate, types, resultClass);
                }
                this._sets = null;
                this._put = null;
                this._constructor = null;
            }
        }
    }

    boolean isInterface(Class<?> intf, Class<?> actual) {
        if (actual != null) {
            Class<?>[] intfs;
            for (Class<?> c : intfs = actual.getInterfaces()) {
                if (c != intf) continue;
                return true;
            }
        }
        return false;
    }

    private void assertConvertable(Class<?> candidate, Class<?>[] types, Class<?> resultClass) {
        Class<?> c;
        Class<?> clazz = c = types == null ? candidate : types[0];
        if (types != null && types.length != 1 || c != null && c != Object.class && !Filters.canConvert(c, resultClass, true)) {
            throw new UserException(_loc.get("cant-convert-result", c, resultClass));
        }
    }

    public Object pack(Object result) {
        if (result == null || this._resultClass == result.getClass()) {
            return result;
        }
        if (this._resultClass == Object.class) {
            return result;
        }
        if (this._resultClass == Object[].class) {
            return new Object[]{result};
        }
        if (this._resultClass == HashMap.class || this._resultClass == Map.class) {
            HashMap<String, Object> map = new HashMap<String, Object>(1, 1.0f);
            map.put(this._aliases[0], result);
            return map;
        }
        if (this._constructor == null && this._sets == null) {
            return Filters.convert(result, this._resultClass);
        }
        return this.packUserType(new Object[]{result});
    }

    public Object pack(Object[] result) {
        if (result == null || result.length == 0) {
            return null;
        }
        if (this._resultClass == Object[].class) {
            if (result.length > this._aliases.length) {
                Object[] trim = new Object[this._aliases.length];
                System.arraycopy(result, 0, trim, 0, trim.length);
                return trim;
            }
            return result;
        }
        if (this._resultClass.isArray()) {
            Class<?> elementType = this._resultClass.getComponentType();
            Object castResult = Array.newInstance(elementType, result.length);
            for (int i = 0; i < result.length; ++i) {
                Array.set(castResult, i, elementType.cast(result[i]));
            }
            return castResult;
        }
        if (this._resultClass == Object.class) {
            return result[0];
        }
        if (this._resultClass == HashMap.class || this._resultClass == Map.class) {
            HashMap<String, Object> map = new HashMap<String, Object>(result.length);
            for (int i = 0; i < this._aliases.length; ++i) {
                map.put(this._aliases[i], result[i]);
            }
            return map;
        }
        if (this._sets == null && this._constructor == null) {
            return Filters.convert(result[0], this._resultClass);
        }
        return this.packUserType(result);
    }

    private Object packUserType(Object[] result) {
        try {
            if (this._constructor != null) {
                return this._constructor.newInstance(result);
            }
            Object user = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(this._resultClass));
            for (int i = 0; i < this._aliases.length; ++i) {
                if (this._sets[i] instanceof Method) {
                    Method meth = (Method)this._sets[i];
                    meth.invoke(user, Filters.convert(result[i], meth.getParameterTypes()[0]));
                    continue;
                }
                if (this._sets[i] instanceof Field) {
                    Field field = (Field)this._sets[i];
                    field.set(user, Filters.convert(result[i], field.getType()));
                    continue;
                }
                if (this._put == null) continue;
                this._put.invoke(user, this._aliases[i], result[i]);
            }
            return user;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (PrivilegedActionException pae) {
            throw new UserException(_loc.get("pack-instantiation-err", this._resultClass), (Throwable)pae.getException());
        }
        catch (InstantiationException ie) {
            throw new UserException(_loc.get("pack-instantiation-err", this._resultClass), (Throwable)ie);
        }
        catch (Exception e) {
            throw new UserException(_loc.get("pack-err", this._resultClass), (Throwable)e);
        }
    }

    private static Member findSet(String alias, Class<?> type, Field[] fields, Method[] methods) {
        if (StringUtils.isEmpty((String)alias)) {
            return null;
        }
        if (type == Object.class) {
            type = null;
        }
        Field field = null;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals(alias)) {
                if (type != null && !Filters.canConvert(type, fields[i].getType(), true)) break;
                return fields[i];
            }
            if (field != null || !fields[i].getName().equalsIgnoreCase(alias) || type != null && !Filters.canConvert(type, fields[i].getType(), true)) continue;
            field = fields[i];
        }
        String setName = "set" + StringUtils.capitalize((String)alias);
        Method method = null;
        boolean eqName = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            if (!methods[i].getName().equalsIgnoreCase(setName) || (params = methods[i].getParameterTypes()).length != 1) continue;
            if (type != null && params[0] == Object.class) {
                if (methods[i].getName().equals(setName)) {
                    eqName = true;
                    method = methods[i];
                    continue;
                }
                if (method != null) continue;
                method = methods[i];
                continue;
            }
            if (type != null && !Filters.canConvert(type, params[0], true)) continue;
            if (methods[i].getName().equals(setName)) {
                return methods[i];
            }
            if (method != null && eqName) continue;
            method = methods[i];
        }
        if (eqName || field == null) {
            return method;
        }
        return field;
    }

    private static Method findPut(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            if (!methods[i].getName().equals("put") || (params = methods[i].getParameterTypes()).length != 2 || params[0] != Object.class || params[1] != Object.class) continue;
            return methods[i];
        }
        return null;
    }

    static {
        _stdTypes.add(Object[].class);
        _stdTypes.add(Object.class);
        _stdTypes.add(Map.class);
        _stdTypes.add(HashMap.class);
        _stdTypes.add(Character.class);
        _stdTypes.add(Boolean.class);
        _stdTypes.add(Byte.class);
        _stdTypes.add(Short.class);
        _stdTypes.add(Integer.class);
        _stdTypes.add(Long.class);
        _stdTypes.add(Float.class);
        _stdTypes.add(Double.class);
        _stdTypes.add(String.class);
        _stdTypes.add(BigInteger.class);
        _stdTypes.add(BigDecimal.class);
        _stdTypes.add(java.util.Date.class);
        _stdTypes.add(Date.class);
        _stdTypes.add(Time.class);
        _stdTypes.add(Timestamp.class);
        _stdTypes.add(Calendar.class);
        _stdTypes.add(GregorianCalendar.class);
    }
}

