/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.xml.namespace.QName;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.PortInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.SingletonBeanInfo;
import org.apache.openejb.assembler.classic.StatelessBeanInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.WsBuilder;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.event.NewEjbAvailableAfterApplicationCreated;
import org.apache.openejb.assembler.classic.util.PojoUtil;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.webservices.PortAddressRegistry;
import org.apache.openejb.core.webservices.PortAddressRegistryImpl;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.openejb.server.webservices.OpenEJBHttpWsRegistry;
import org.apache.openejb.server.webservices.WsRegistry;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.StringTemplate;

public abstract class WsService
implements ServerService,
SelfManaging {
    public static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_WS, WsService.class);
    public static final String WS_ADDRESS_FORMAT = "openejb.wsAddress.format";
    public static final String WS_FORCE_ADDRESS = "openejb.webservice.deployment.address";
    private static final boolean OLD_WEBSERVICE_DEPLOYMENT = SystemInstance.get().getOptions().get("openejb.webservice.old-deployment", false);
    private StringTemplate wsAddressTemplate;
    private PortAddressRegistry portAddressRegistry;
    private CoreContainerSystem containerSystem;
    private Assembler assembler;
    private WsRegistry wsRegistry;
    private String realmName;
    private String transportGuarantee;
    private String authMethod;
    private String virtualHost;
    private final ConcurrentMap<AppInfo, Collection<BeanContext>> deployedApplications = new ConcurrentHashMap<AppInfo, Collection<BeanContext>>();
    private final Set<WebAppInfo> deployedWebApps = new HashSet<WebAppInfo>();
    private final Map<String, String> ejbLocations = new TreeMap<String, String>();
    private final Map<String, String> ejbAddresses = new TreeMap<String, String>();
    private final Map<String, String> servletAddresses = new TreeMap<String, String>();
    private final Map<String, List<EndpointInfo>> addressesByApplication = new TreeMap<String, List<EndpointInfo>>();

    public WsService() {
        String format = SystemInstance.get().getOptions().get(WS_ADDRESS_FORMAT, "/{ejbDeploymentId}");
        this.wsAddressTemplate = new StringTemplate(format);
    }

    public StringTemplate getWsAddressTemplate() {
        return this.wsAddressTemplate;
    }

    public void setWsAddressTemplate(StringTemplate wsAddressTemplate) {
        this.wsAddressTemplate = wsAddressTemplate;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getIP() {
        return "n/a";
    }

    public int getPort() {
        return -1;
    }

    public void init(Properties props) throws Exception {
        if (props == null) {
            return;
        }
        String format = props.getProperty(WS_ADDRESS_FORMAT);
        if (format != null) {
            this.wsAddressTemplate = new StringTemplate(format);
        }
        this.realmName = props.getProperty("realmName");
        this.transportGuarantee = props.getProperty("transportGuarantee");
        this.authMethod = props.getProperty("authMethod");
        this.virtualHost = props.getProperty("virtualHost", "localhost");
    }

    public void start() throws ServiceException {
        this.wsRegistry = (WsRegistry)SystemInstance.get().getComponent(WsRegistry.class);
        if (this.wsRegistry == null && SystemInstance.get().getComponent(HttpListenerRegistry.class) != null) {
            this.wsRegistry = new OpenEJBHttpWsRegistry();
        }
        if (this.portAddressRegistry == null) {
            this.portAddressRegistry = new PortAddressRegistryImpl();
            SystemInstance.get().setComponent(PortAddressRegistry.class, (Object)this.portAddressRegistry);
        }
        this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.portAddressRegistry = (PortAddressRegistry)SystemInstance.get().getComponent(PortAddressRegistry.class);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        SystemInstance.get().setComponent(WsService.class, (Object)this);
        if (this.assembler != null) {
            SystemInstance.get().addObserver((Object)this);
            for (AppInfo appInfo : this.assembler.getDeployedApplications()) {
                AppContext appContext = this.containerSystem.getAppContext((Object)appInfo.appId);
                this.deploy(new AssemblerAfterApplicationCreated(appInfo, appContext, null));
            }
        }
    }

    public void stop() throws ServiceException {
        if (this.assembler != null) {
            SystemInstance.get().removeObserver((Object)this);
            for (AppInfo appInfo : new ArrayList(this.deployedApplications.keySet())) {
                this.undeploy(new AssemblerBeforeApplicationDestroyed(appInfo, null));
            }
            this.assembler = null;
            if (SystemInstance.get().getComponent(WsService.class) == this) {
                SystemInstance.get().removeComponent(WsService.class);
            }
        }
    }

    protected abstract HttpListener createEjbWsContainer(URL var1, PortData var2, BeanContext var3, ServiceConfiguration var4) throws Exception;

    protected abstract void destroyEjbWsContainer(String var1);

    protected abstract HttpListener createPojoWsContainer(ClassLoader var1, URL var2, PortData var3, String var4, Class var5, Context var6, String var7, Map<String, Object> var8, ServiceConfiguration var9) throws Exception;

    protected abstract void destroyPojoWsContainer(String var1);

    public void newEjbToDeploy(@Observes NewEjbAvailableAfterApplicationCreated event) {
        AppInfo app = event.getApp();
        if (!this.deployedApplications.containsKey(app)) {
            this.deployedApplications.putIfAbsent(app, new LinkedList());
        }
        this.deployApp(app, event.getBeanContexts());
    }

    public void deploy(@Observes AssemblerAfterApplicationCreated event) {
        AppInfo appInfo = event.getApp();
        if (this.deployedApplications.put(appInfo, new LinkedList()) == null) {
            this.deployApp(appInfo, event.getContext().getBeanContexts());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployApp(AppInfo appInfo, Collection<BeanContext> ejbs) {
        Collection alreadyDeployed = (Collection)this.deployedApplications.get(appInfo);
        HashMap<String, String> webContextByEjb = new HashMap<String, String>();
        for (WebAppInfo webApp : appInfo.webApps) {
            for (String ejb : webApp.ejbWebServices) {
                webContextByEjb.put(ejb, webApp.contextRoot);
            }
        }
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("appId", appInfo.path);
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            TreeMap<String, PortInfo> ports = new TreeMap<String, PortInfo>();
            for (PortInfo port : ejbJar.portInfos) {
                ports.put(port.serviceLink, port);
            }
            URL moduleBaseUrl = null;
            if (ejbJar.path != null) {
                try {
                    moduleBaseUrl = new File(ejbJar.path).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    logger.error("Invalid ejb jar location " + ejbJar.path, (Throwable)e);
                }
            }
            StringTemplate deploymentIdTemplate = this.wsAddressTemplate;
            if (ejbJar.properties.containsKey(WS_ADDRESS_FORMAT)) {
                String format = ejbJar.properties.getProperty(WS_ADDRESS_FORMAT);
                logger.info("Using openejb.wsAddress.format '" + format + "'");
                deploymentIdTemplate = new StringTemplate(format);
            }
            contextData.put("ejbJarId", ejbJar.moduleName);
            String host = this.host(ejbJar, appInfo);
            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                PortInfo portInfo;
                BeanContext beanContext;
                if (!(bean instanceof StatelessBeanInfo) && !(bean instanceof SingletonBeanInfo) || (beanContext = this.containerSystem.getBeanContext((Object)bean.ejbDeploymentId)) == null || ejbs != null && !ejbs.contains(beanContext) || (portInfo = (PortInfo)ports.get(bean.ejbName)) == null || alreadyDeployed.contains(beanContext)) continue;
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(beanContext.getClassLoader());
                try {
                    String context;
                    PortData port = WsBuilder.toPortData((PortInfo)portInfo, (Collection)beanContext.getInjections(), (URL)moduleBaseUrl, (ClassLoader)beanContext.getClassLoader());
                    HttpListener container = this.createEjbWsContainer(moduleBaseUrl, port, beanContext, new ServiceConfiguration(beanContext.getProperties(), (Collection)appInfo.services));
                    String location = port.getLocation();
                    if (location == null) {
                        location = this.autoAssignWsLocation(bean, port, contextData, deploymentIdTemplate);
                    }
                    if (!location.startsWith("/")) {
                        location = "/" + location;
                    }
                    this.ejbLocations.put(bean.ejbDeploymentId, location);
                    ClassLoader classLoader = beanContext.getClassLoader();
                    if (this.wsRegistry == null) continue;
                    String auth = this.authMethod;
                    String realm = this.realmName;
                    String transport = this.transportGuarantee;
                    if ("BASIC".equals(portInfo.authMethod) || "DIGEST".equals(portInfo.authMethod) || "CLIENT-CERT".equals(portInfo.authMethod)) {
                        auth = portInfo.authMethod;
                        realm = portInfo.realmName;
                        transport = portInfo.transportGuarantee;
                    }
                    if ((context = (String)webContextByEjb.get(bean.ejbClass)) == null && !OLD_WEBSERVICE_DEPLOYMENT) {
                        context = ejbJar.moduleName;
                    }
                    List<String> addresses = this.wsRegistry.addWsContainer(container, classLoader, context, host, location, realm, transport, auth);
                    alreadyDeployed.add(beanContext);
                    String address = HttpUtil.selectSingleAddress(addresses);
                    if (address == null) continue;
                    this.portAddressRegistry.addPort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId, portInfo.wsdlPort, portInfo.seiInterfaceName, address);
                    this.setWsdl(container, address);
                    logger.info("Webservice(wsdl=" + address + ", qname=" + port.getWsdlService() + ") --> Ejb(id=" + portInfo.portId + ")");
                    this.ejbAddresses.put(bean.ejbDeploymentId, address);
                    this.addressesForApp(appInfo.appId).add(new EndpointInfo(address, port.getWsdlService(), beanContext.getBeanClass().getName()));
                }
                catch (Throwable e) {
                    logger.error("Error deploying JAX-WS Web Service for EJB " + beanContext.getDeploymentID(), e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        }
        if (ejbs == null || appInfo.webAppAlone) {
            for (WebAppInfo webApp : appInfo.webApps) {
                this.afterApplicationCreated(appInfo, webApp);
            }
        }
    }

    private String host(EjbJarInfo jar, AppInfo app) {
        for (WebAppInfo web : app.webApps) {
            if (!jar.moduleId.equals(web.moduleId)) continue;
            if (web.host == null) break;
            return web.host;
        }
        return this.virtualHost;
    }

    protected void setWsdl(HttpListener listener, String wsdl) {
    }

    private List<EndpointInfo> addressesForApp(String appId) {
        if (!this.addressesByApplication.containsKey(appId)) {
            this.addressesByApplication.put(appId, new ArrayList());
        }
        return this.addressesByApplication.get(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterApplicationCreated(AppInfo appInfo, WebAppInfo webApp) {
        WebContext webContext = this.containerSystem.getWebContextByHost(webApp.moduleId, webApp.host != null ? webApp.host : this.virtualHost);
        if (webContext == null) {
            return;
        }
        if (!this.deployedWebApps.add(webApp)) {
            return;
        }
        TreeMap<String, PortInfo> ports = new TreeMap<String, PortInfo>();
        for (PortInfo port : webApp.portInfos) {
            ports.put(port.serviceLink, port);
        }
        URL moduleBaseUrl = null;
        try {
            moduleBaseUrl = new File(webApp.path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.error("Invalid ejb jar location " + webApp.path, (Throwable)e);
        }
        Collection pojoConfiguration = null;
        for (ServletInfo servlet : webApp.servlets) {
            PortInfo portInfo;
            if (servlet.servletName == null || (portInfo = (PortInfo)ports.get(servlet.servletName)) == null) continue;
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = webContext.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Collection injections = webContext.getInjections();
                Context context = webContext.getJndiEnc();
                Class<?> target = classLoader.loadClass(servlet.servletClass);
                Map bindings = webContext.getBindings();
                PortData port = WsBuilder.toPortData((PortInfo)portInfo, (Collection)injections, (URL)moduleBaseUrl, (ClassLoader)classLoader);
                pojoConfiguration = PojoUtil.findPojoConfig(pojoConfiguration, (AppInfo)appInfo, (WebAppInfo)webApp);
                HttpListener container = this.createPojoWsContainer(classLoader, moduleBaseUrl, port, portInfo.serviceLink, target, context, webApp.contextRoot, bindings, new ServiceConfiguration(PojoUtil.findConfiguration((Collection)pojoConfiguration, (String)target.getName()), (Collection)appInfo.services));
                if (this.wsRegistry == null) continue;
                String auth = this.authMethod;
                String realm = this.realmName;
                String transport = this.transportGuarantee;
                if ("BASIC".equals(portInfo.authMethod) || "DIGEST".equals(portInfo.authMethod) || "CLIENT-CERT".equals(portInfo.authMethod)) {
                    auth = portInfo.authMethod;
                    realm = portInfo.realmName;
                    transport = portInfo.transportGuarantee;
                }
                List<String> addresses = this.wsRegistry.setWsContainer(container, classLoader, webApp.contextRoot, this.host(webApp), servlet, realm, transport, auth);
                String address = HttpUtil.selectSingleAddress(addresses);
                this.portAddressRegistry.addPort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId, portInfo.wsdlPort, portInfo.seiInterfaceName, address);
                this.setWsdl(container, address);
                logger.info("Webservice(wsdl=" + address + ", qname=" + port.getWsdlService() + ") --> Pojo(id=" + portInfo.portId + ")");
                this.servletAddresses.put(webApp.moduleId + "." + servlet.servletName, address);
                this.addressesForApp(webApp.moduleId).add(new EndpointInfo(address, port.getWsdlService(), target.getName()));
            }
            catch (Throwable e) {
                logger.error("Error deploying CXF webservice for servlet " + portInfo.serviceLink, e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private String host(WebAppInfo webApp) {
        return webApp.host == null ? this.virtualHost : webApp.host;
    }

    public void undeploy(@Observes AssemblerBeforeApplicationDestroyed event) {
        AppInfo appInfo = event.getApp();
        if (this.deployedApplications.remove(appInfo) != null) {
            PortInfo portInfo;
            TreeMap<String, PortInfo> ports;
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                ports = new TreeMap<String, PortInfo>();
                for (PortInfo port : ejbJar.portInfos) {
                    ports.put(port.serviceLink, port);
                }
                for (EnterpriseBeanInfo enterpriseBean : ejbJar.enterpriseBeans) {
                    BeanContext beanContext;
                    if (!(enterpriseBean instanceof StatelessBeanInfo) && !(enterpriseBean instanceof SingletonBeanInfo) || (portInfo = (PortInfo)ports.get(enterpriseBean.ejbName)) == null || (beanContext = this.containerSystem.getBeanContext((Object)enterpriseBean.ejbDeploymentId)) == null) continue;
                    String address = this.ejbAddresses.remove(enterpriseBean.ejbDeploymentId);
                    this.addressesForApp(appInfo.appId).remove(new EndpointInfo(address, portInfo.wsdlPort, beanContext.getBeanClass().getName()));
                    if (address != null) {
                        this.portAddressRegistry.removePort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId, portInfo.seiInterfaceName);
                    }
                    String location = this.ejbLocations.get(enterpriseBean.ejbDeploymentId);
                    if (this.wsRegistry != null && location != null) {
                        this.wsRegistry.removeWsContainer(location);
                    }
                    this.destroyEjbWsContainer(enterpriseBean.ejbDeploymentId);
                    this.ejbLocations.remove(enterpriseBean.ejbDeploymentId);
                }
            }
            for (WebAppInfo webApp : appInfo.webApps) {
                this.deployedWebApps.remove(webApp);
                ports = new TreeMap();
                for (PortInfo port : webApp.portInfos) {
                    ports.put(port.serviceLink, port);
                }
                for (ServletInfo servlet : webApp.servlets) {
                    if (servlet.servletClass == null || (portInfo = (PortInfo)ports.remove(servlet.servletClass)) == null && (portInfo = (PortInfo)ports.remove(servlet.servletName)) == null) continue;
                    String address = this.servletAddresses.remove(webApp.moduleId + "." + servlet.servletName);
                    if (address != null) {
                        this.portAddressRegistry.removePort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId, portInfo.seiInterfaceName);
                    }
                    if (this.wsRegistry != null) {
                        try {
                            this.wsRegistry.clearWsContainer(webApp.contextRoot, this.host(webApp), servlet);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    this.destroyPojoWsContainer(portInfo.serviceLink);
                }
                this.addressesByApplication.remove(webApp.moduleId);
            }
            this.addressesByApplication.remove(appInfo.appId);
        }
    }

    private String autoAssignWsLocation(EnterpriseBeanInfo bean, PortData port, Map<String, String> contextData, StringTemplate template) {
        if (bean.properties.containsKey(WS_FORCE_ADDRESS)) {
            return bean.properties.getProperty(WS_FORCE_ADDRESS);
        }
        contextData.put("ejbDeploymentId", bean.ejbDeploymentId);
        contextData.put("ejbType", WsService.getEjbType(bean.type));
        contextData.put("ejbClass", bean.ejbClass);
        contextData.put("ejbClass.simpleName", bean.ejbClass.substring(bean.ejbClass.lastIndexOf(46) + 1));
        contextData.put("ejbName", bean.ejbName);
        contextData.put("portComponentName", port.getPortName().getLocalPart());
        contextData.put("wsdlPort", port.getWsdlPort().getLocalPart());
        contextData.put("wsdlService", port.getWsdlService().getLocalPart());
        return template.apply(contextData);
    }

    public static String getEjbType(int type) {
        if (type == 1) {
            return "StatefulBean";
        }
        if (type == 2) {
            return "StatelessBean";
        }
        if (type == 4) {
            return "SingletonBean";
        }
        if (type == 5) {
            return "ManagedBean";
        }
        if (type == 3) {
            return "MessageDrivenBean";
        }
        if (type == 0) {
            return "StatefulBean";
        }
        return "UnknownBean";
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("CxfService cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException("CxfService cannot be invoked directly");
    }

    public Map<String, List<EndpointInfo>> getAddressesByApplication() {
        return this.addressesByApplication;
    }

    public static class EndpointInfo {
        public String address;
        public String portName;
        public String classname;

        public EndpointInfo(String address, QName portName, String name) {
            this.address = address;
            this.classname = name;
            this.portName = portName != null ? portName.toString() : "null";
        }
    }
}

