/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.DelegatingJoinable;
import org.apache.openjpa.jdbc.meta.Joinable;
import org.apache.openjpa.jdbc.meta.strats.AbstractClassStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.MetaDataException;

public class VerticalClassStrategy
extends AbstractClassStrategy {
    private static final long serialVersionUID = 1L;
    public static final String ALIAS = "vertical";
    private static final Localizer _loc = Localizer.forPackage(VerticalClassStrategy.class);
    private Boolean _fkOid = null;

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    public void map(boolean adapt) {
        ClassMapping sup = this.cls.getMappedPCSuperclassMapping();
        if (sup == null) {
            throw new MetaDataException(_loc.get("not-sub", (Object)this.cls));
        }
        ClassMappingInfo info = this.cls.getMappingInfo();
        info.assertNoIndex((MetaDataContext)this.cls, false);
        info.assertNoUnique((MetaDataContext)this.cls, false);
        Table table = info.getTable(this.cls, adapt);
        ForeignKey fk = info.getSuperclassJoin(this.cls, table, adapt);
        Column[] pkCols = fk.getColumns();
        this.cls.setTable(table);
        this.cls.setJoinForeignKey(fk);
        this.cls.setPrimaryKeyColumns(pkCols);
        this.cls.setColumnIO(info.getColumnIO());
        PrimaryKey pk = table.getPrimaryKey();
        if (pk == null) {
            DBIdentifier pkname = DBIdentifier.NULL;
            if (adapt) {
                pkname = this.cls.getMappingRepository().getMappingDefaults().getPrimaryKeyIdentifier(this.cls, table);
            }
            pk = table.addPrimaryKey(pkname);
            pk.setLogical(!adapt);
            pk.setColumns(pkCols);
        }
        for (int i = 0; i < pkCols.length; ++i) {
            if (this.cls.getJoinable(pkCols[i]) != null) continue;
            Joinable join = sup.assertJoinable(fk.getPrimaryKeyColumn(pkCols[i]));
            join = new DelegatingJoinable(join, fk);
            Column[] cols = join.getColumns();
            for (int j = 0; j < cols.length; ++j) {
                this.cls.setJoinable(cols[j], join);
            }
        }
    }

    @Override
    public void initialize() {
        ClassMapping sup = this.cls.getMappedPCSuperclassMapping();
        this._fkOid = sup.isForeignKeyObjectId(this.cls.getJoinForeignKey());
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Row row = rm.getRow(this.cls.getTable(), 1, sm, true);
        row.setPrimaryKey(this.cls.getColumnIO(), sm);
        row.setForeignKey(this.cls.getJoinForeignKey(), this.cls.getColumnIO(), sm);
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Row row = rm.getRow(this.cls.getTable(), 0, sm, false);
        if (row != null) {
            row.wherePrimaryKey(sm);
            row.whereForeignKey(this.cls.getJoinForeignKey(), sm);
        }
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Row row = rm.getRow(this.cls.getTable(), 2, sm, true);
        row.wherePrimaryKey(sm);
        row.whereForeignKey(this.cls.getJoinForeignKey(), sm);
    }

    @Override
    public boolean isPrimaryKeyObjectId(boolean hasAll) {
        return Boolean.TRUE.equals(this._fkOid) || !hasAll && this._fkOid == null;
    }

    @Override
    public Joins joinSuperclass(Joins joins, boolean toThis) {
        if (toThis) {
            return joins.outerJoin(this.cls.getJoinForeignKey(), true, false);
        }
        return joins.join(this.cls.getJoinForeignKey(), false, false);
    }

    @Override
    public boolean supportsEagerSelect(Select sel, OpenJPAStateManager sm, JDBCStore store, ClassMapping base, JDBCFetchConfiguration fetch) {
        return store.getDBDictionary().canOuterJoin(sel.getJoinSyntax(), this.cls.getJoinForeignKey());
    }
}

