/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.lang.reflect.Method;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.MetaDataException;

public class EnumValueHandler
extends AbstractValueHandler {
    private static final long serialVersionUID = 1L;
    private Enum<?>[] _vals = null;
    private boolean _ordinal = false;
    private static final Localizer _loc = Localizer.forPackage(EnumValueHandler.class);

    public boolean getStoreOrdinal() {
        return this._ordinal;
    }

    public void setStoreOrdinal(boolean ordinal) {
        this._ordinal = ordinal;
    }

    @Override
    @Deprecated
    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        return this.map(vm, colName, io, adapt);
    }

    public Column[] map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt) {
        try {
            Method m = vm.getType().getMethod("values", null);
            this._vals = (Enum[])m.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new MetaDataException(_loc.get("not-enum-field", (Object)vm.getFieldMapping().getFullName(true), (Object)Exceptions.toClassName((Class)vm.getType()))).setCause((Throwable)e);
        }
        Column col = new Column();
        col.setIdentifier(name);
        if (this._ordinal) {
            col.setJavaType(7);
        } else {
            int len = 20;
            for (int i = 0; i < this._vals.length; ++i) {
                len = Math.max(this._vals[i].name().length(), len);
            }
            col.setJavaType(9);
            col.setSize(len);
        }
        return new Column[]{col};
    }

    @Override
    public boolean isVersionable(ValueMapping vm) {
        return true;
    }

    @Override
    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        if (val == null) {
            return null;
        }
        if (this._ordinal) {
            return ((Enum)val).ordinal();
        }
        return ((Enum)val).name();
    }

    @Override
    public Object toObjectValue(ValueMapping vm, Object val) {
        if (val == null) {
            return null;
        }
        if (this._ordinal) {
            return this._vals[((Number)val).intValue()];
        }
        return Enum.valueOf(vm.getType(), (String)val);
    }
}

