/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.validation;

import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.validation.ValidationException;
import org.apache.openjpa.validation.Validator;

public class ValidatingLifecycleEventManager
extends LifecycleEventManager
implements Configurable {
    private OpenJPAConfiguration _conf = null;
    private Validator _validator = null;
    protected boolean _validationEnabled = true;

    public void endConfiguration() {
        this._validator = (Validator)this._conf.getValidatorInstance();
    }

    public void setConfiguration(Configuration conf) {
        if (conf instanceof OpenJPAConfiguration) {
            this._conf = (OpenJPAConfiguration)conf;
        }
    }

    public void startConfiguration() {
    }

    @Override
    public boolean hasUpdateListeners(Object source, ClassMetaData meta) {
        if (this._validator == null) {
            return super.hasUpdateListeners(source, meta);
        }
        return this._validator.validating(source, 20) || super.hasUpdateListeners(source, meta);
    }

    @Override
    public boolean hasPersistListeners(Object source, ClassMetaData meta) {
        if (this._validator == null) {
            return super.hasPersistListeners(source, meta);
        }
        return this._validator.validating(source, 0) || super.hasPersistListeners(source, meta);
    }

    @Override
    public boolean hasDeleteListeners(Object source, ClassMetaData meta) {
        if (this._validator == null) {
            return super.hasDeleteListeners(source, meta);
        }
        return this._validator.validating(source, 7) || super.hasDeleteListeners(source, meta);
    }

    @Override
    public Exception[] fireEvent(Object source, ClassMetaData meta, int type) {
        return this.fireEvent(source, null, meta, type);
    }

    @Override
    public Exception[] fireEvent(Object source, Object related, ClassMetaData meta, int type) {
        ValidationException vex;
        Exception[] evx = super.fireEvent(source, related, meta, type);
        if (evx != null && evx.length > 0 && this.isFailFast()) {
            return evx;
        }
        if (this._validationEnabled && this._validator != null && this._validator.validating(source, type) && (vex = this._validator.validate(source, type)) != null) {
            if (evx == null || evx.length == 0) {
                evx = new Exception[]{vex};
            } else {
                Exception[] vevx = new Exception[evx.length + 1];
                System.arraycopy(vevx, 0, evx, 0, evx.length);
                vevx[evx.length + 1] = vex;
                evx = vevx;
            }
        }
        return evx;
    }

    public boolean isValidationEnabled() {
        return this._validationEnabled;
    }

    public boolean setValidationEnabled(boolean enabled) {
        boolean val = this._validationEnabled;
        this._validationEnabled = enabled;
        return val;
    }
}

