/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.flagbitspane;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.debugger.flagbitspane.Flag;

class FieldFlag
extends Flag {
    private final COSDictionary dictionary;

    FieldFlag(COSDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    String getFlagType() {
        COSName fieldType = this.dictionary.getCOSName(COSName.FT);
        if (COSName.TX.equals((Object)fieldType)) {
            return "Text field flag";
        }
        if (COSName.BTN.equals((Object)fieldType)) {
            return "Button field flag";
        }
        if (COSName.CH.equals((Object)fieldType)) {
            return "Choice field flag";
        }
        return null;
    }

    @Override
    String getFlagValue() {
        return "Flag value: " + this.dictionary.getInt(COSName.FF);
    }

    @Override
    Object[][] getFlagBits() {
        int flagValue = this.dictionary.getInt(COSName.FF);
        COSName fieldType = this.dictionary.getCOSName(COSName.FT);
        if (COSName.TX.equals((Object)fieldType)) {
            return this.getTextFieldFlagBits(flagValue);
        }
        if (COSName.BTN.equals((Object)fieldType)) {
            return this.getButtonFieldFlagBits(flagValue);
        }
        if (COSName.CH.equals((Object)fieldType)) {
            return this.getChoiceFieldFlagBits(flagValue);
        }
        return null;
    }

    private Object[][] getTextFieldFlagBits(int flagValue) {
        return new Object[][]{{1, "ReadOnly", this.isFlagBitSet(flagValue, 1)}, {2, "Required", this.isFlagBitSet(flagValue, 2)}, {3, "NoExport", this.isFlagBitSet(flagValue, 3)}, {13, "Multiline", this.isFlagBitSet(flagValue, 13)}, {14, "Password", this.isFlagBitSet(flagValue, 14)}, {21, "FileSelect", this.isFlagBitSet(flagValue, 21)}, {23, "DoNotSpellCheck", this.isFlagBitSet(flagValue, 23)}, {24, "DoNotScroll", this.isFlagBitSet(flagValue, 24)}, {25, "Comb", this.isFlagBitSet(flagValue, 25)}, {26, "RichText", this.isFlagBitSet(flagValue, 26)}};
    }

    private Object[][] getButtonFieldFlagBits(int flagValue) {
        return new Object[][]{{1, "ReadOnly", this.isFlagBitSet(flagValue, 1)}, {2, "Required", this.isFlagBitSet(flagValue, 2)}, {3, "NoExport", this.isFlagBitSet(flagValue, 3)}, {15, "NoToggleToOff", this.isFlagBitSet(flagValue, 15)}, {16, "Radio", this.isFlagBitSet(flagValue, 16)}, {17, "Pushbutton", this.isFlagBitSet(flagValue, 17)}, {26, "RadiosInUnison", this.isFlagBitSet(flagValue, 26)}};
    }

    private Object[][] getChoiceFieldFlagBits(int flagValue) {
        return new Object[][]{{1, "ReadOnly", this.isFlagBitSet(flagValue, 1)}, {2, "Required", this.isFlagBitSet(flagValue, 2)}, {3, "NoExport", this.isFlagBitSet(flagValue, 3)}, {18, "Combo", this.isFlagBitSet(flagValue, 18)}, {19, "Edit", this.isFlagBitSet(flagValue, 19)}, {20, "Sort", this.isFlagBitSet(flagValue, 20)}, {22, "MultiSelect", this.isFlagBitSet(flagValue, 22)}, {23, "DoNotSpellCheck", this.isFlagBitSet(flagValue, 23)}, {27, "CommitOnSelChange", this.isFlagBitSet(flagValue, 27)}};
    }

    private Boolean isFlagBitSet(int flagValue, int bitPosition) {
        int binaryFormat = 1 << bitPosition - 1;
        return (flagValue & binaryFormat) == binaryFormat;
    }
}

