/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingView;
import org.apache.pdfbox.debugger.fontencodingpane.FontPane;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

class Type0Font
extends FontPane {
    public static final String NO_GLYPH = "No glyph";
    private final FontEncodingView view;
    private int totalAvailableGlyph = 0;

    Type0Font(PDCIDFont descendantFont, PDType0Font parentFont) throws IOException {
        Object[][] cidtogid = this.readCIDToGIDMap(descendantFont, (PDFont)parentFont);
        if (cidtogid != null) {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("Font", descendantFont.getName());
            attributes.put("CIDs", Integer.toString(cidtogid.length));
            attributes.put("Embedded", Boolean.toString(descendantFont.isEmbedded()));
            this.view = new FontEncodingView(cidtogid, attributes, new String[]{"CID", "GID", "Unicode Character", "Glyph"}, this.getYBounds(cidtogid, 3));
        } else {
            Object[][] tab = this.readMap(descendantFont, parentFont);
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("Font", descendantFont.getName());
            attributes.put("CIDs", Integer.toString(tab.length));
            attributes.put("Glyphs", Integer.toString(this.totalAvailableGlyph));
            attributes.put("Standard 14", Boolean.toString(parentFont.isStandard14()));
            attributes.put("Embedded", Boolean.toString(descendantFont.isEmbedded()));
            this.view = new FontEncodingView(tab, attributes, new String[]{"Code", "CID", "GID", "Unicode Character", "Glyph"}, this.getYBounds(tab, 4));
        }
    }

    private Object[][] readMap(PDCIDFont descendantFont, PDType0Font parentFont) throws IOException {
        int codes = 0;
        for (int code = 0; code < 65535; ++code) {
            if (!descendantFont.hasGlyph(code)) continue;
            ++codes;
        }
        Object[][] tab = new Object[codes][5];
        int index = 0;
        for (int code = 0; code < 65535; ++code) {
            if (!descendantFont.hasGlyph(code)) continue;
            tab[index][0] = code;
            tab[index][1] = descendantFont.codeToCID(code);
            tab[index][2] = descendantFont.codeToGID(code);
            tab[index][3] = parentFont.toUnicode(code);
            GeneralPath path = descendantFont.getPath(code);
            tab[index][4] = path;
            if (!path.getBounds2D().isEmpty()) {
                ++this.totalAvailableGlyph;
            }
            ++index;
        }
        return tab;
    }

    private Object[][] readCIDToGIDMap(PDCIDFont font, PDFont parentFont) throws IOException {
        Object[][] cid2gid = null;
        COSDictionary dict = font.getCOSObject();
        COSBase map = dict.getDictionaryObject(COSName.CID_TO_GID_MAP);
        if (map instanceof COSStream) {
            COSStream stream = (COSStream)map;
            COSInputStream is = stream.createInputStream();
            byte[] mapAsBytes = IOUtils.toByteArray((InputStream)is);
            IOUtils.closeQuietly((Closeable)is);
            int numberOfInts = mapAsBytes.length / 2;
            cid2gid = new Object[numberOfInts][4];
            int offset = 0;
            for (int index = 0; index < numberOfInts; ++index) {
                int gid = (mapAsBytes[offset] & 0xFF) << 8 | mapAsBytes[offset + 1] & 0xFF;
                cid2gid[index][0] = index;
                cid2gid[index][1] = gid;
                if (gid != 0 && parentFont.toUnicode(index) != null) {
                    cid2gid[index][2] = parentFont.toUnicode(index);
                }
                GeneralPath path = font.getPath(index);
                cid2gid[index][3] = path;
                if (!path.getBounds2D().isEmpty()) {
                    ++this.totalAvailableGlyph;
                }
                offset += 2;
            }
        }
        return cid2gid;
    }

    @Override
    public JPanel getPanel() {
        if (this.view != null) {
            return this.view.getPanel();
        }
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(300, 500));
        return panel;
    }
}

