/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.scraper.ResultHandler;
import org.apache.plc4x.java.scraper.ScrapeJob;
import org.apache.plc4x.java.scraper.Scraper;
import org.apache.plc4x.java.scraper.ScraperTask;
import org.apache.plc4x.java.scraper.ScraperTaskImpl;
import org.apache.plc4x.java.scraper.config.ScraperConfiguration;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.util.PercentageAboveThreshold;
import org.apache.plc4x.java.utils.connectionpool.PooledPlcDriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScraperImpl
implements Scraper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScraperImpl.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("scheduler-thread-%d").daemon(false).build());
    private final ExecutorService handlerPool = Executors.newFixedThreadPool(4, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("handler-thread-%d").daemon(true).build());
    private final ResultHandler resultHandler;
    private final MultiValuedMap<ScrapeJob, ScraperTask> tasks = new ArrayListValuedHashMap();
    private final MultiValuedMap<ScraperTask, ScheduledFuture<?>> futures = new ArrayListValuedHashMap();
    private final PlcDriverManager driverManager;
    private final List<ScrapeJob> jobs;

    public ScraperImpl(ResultHandler resultHandler, PlcDriverManager driverManager, List<ScrapeJob> jobs) {
        this.resultHandler = resultHandler;
        Validate.notEmpty(jobs);
        this.driverManager = driverManager;
        this.jobs = jobs;
    }

    public ScraperImpl(ScraperConfiguration config, ResultHandler resultHandler) throws ScraperException {
        this(resultHandler, (PlcDriverManager)ScraperImpl.createPooledDriverManager(), config.getJobs());
    }

    private static PooledPlcDriverManager createPooledDriverManager() {
        return new PooledPlcDriverManager(pooledPlcConnectionFactory -> {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setMinIdlePerKey(1);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)pooledPlcConnectionFactory, poolConfig);
        });
    }

    @Override
    public void start() {
        LOGGER.info("Starting jobs...");
        this.jobs.stream().flatMap(job -> job.getSourceConnections().entrySet().stream().map(entry -> Triple.of((Object)job, (Object)((String)entry.getKey()), (Object)((String)entry.getValue())))).forEach(tuple -> {
            LOGGER.debug("Register task for job {} for conn {} ({}) at rate {} ms", new Object[]{((ScrapeJob)tuple.getLeft()).getJobName(), tuple.getMiddle(), tuple.getRight(), ((ScrapeJob)tuple.getLeft()).getScrapeRate()});
            ScraperTaskImpl task = new ScraperTaskImpl(this.driverManager, ((ScrapeJob)tuple.getLeft()).getJobName(), (String)tuple.getMiddle(), (String)tuple.getRight(), ((ScrapeJob)tuple.getLeft()).getFields(), 1000L, this.handlerPool, this.resultHandler);
            this.tasks.put((Object)((ScrapeJob)tuple.getLeft()), (Object)task);
            ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(task, 0L, ((ScrapeJob)tuple.getLeft()).getScrapeRate(), TimeUnit.MILLISECONDS);
            this.futures.put((Object)task, future);
        });
        this.scheduler.scheduleAtFixedRate(() -> {
            for (Map.Entry entry : this.tasks.entries()) {
                DescriptiveStatistics statistics = ((ScraperTask)entry.getValue()).getLatencyStatistics();
                String msg = String.format(Locale.ENGLISH, "Job statistics (%s, %s) number of requests: %d (%d success, %.1f %% failed, %.1f %% too slow), min latency: %.2f ms, mean latency: %.2f ms, median: %.2f ms", ((ScraperTask)entry.getValue()).getJobName(), ((ScraperTask)entry.getValue()).getConnectionAlias(), ((ScraperTask)entry.getValue()).getRequestCounter(), ((ScraperTask)entry.getValue()).getSuccessfullRequestCounter(), ((ScraperTask)entry.getValue()).getPercentageFailed(), statistics.apply((UnivariateStatistic)new PercentageAboveThreshold((double)((ScrapeJob)entry.getKey()).getScrapeRate() * 1000000.0)), statistics.getMin() * 1.0E-6, statistics.getMean() * 1.0E-6, statistics.getPercentile(50.0) * 1.0E-6);
                LOGGER.debug(msg);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public int getNumberOfActiveTasks() {
        return (int)this.futures.entries().stream().filter(entry -> !((ScheduledFuture)entry.getValue()).isDone()).count();
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping scraper...");
        for (Map.Entry entry : this.futures.entries()) {
            LOGGER.debug("Stopping task {}...", entry.getKey());
            ((ScheduledFuture)entry.getValue()).cancel(true);
        }
        this.futures.clear();
    }
}

