/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.javax.ws.rs.ProcessingException;
import org.apache.pulsar.shade.javax.ws.rs.client.Client;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncCompletionHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.BoundRequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.Response;
import org.apache.pulsar.shade.org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.apache.pulsar.shade.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import org.apache.pulsar.shade.org.glassfish.jersey.client.ClientRequest;
import org.apache.pulsar.shade.org.glassfish.jersey.client.ClientResponse;
import org.apache.pulsar.shade.org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.apache.pulsar.shade.org.glassfish.jersey.client.spi.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpConnector
implements Connector {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpConnector.class);
    private final AsyncHttpClient httpClient;
    private final PulsarServiceNameResolver serviceNameResolver;

    public AsyncHttpConnector(Client client, ClientConfigurationData conf) {
        this((Integer)client.getConfiguration().getProperty("org.apache.pulsar.shade.jersey.config.client.connectTimeout"), (Integer)client.getConfiguration().getProperty("org.apache.pulsar.shade.jersey.config.client.readTimeout"), 300000, conf);
    }

    public AsyncHttpConnector(int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs, ClientConfigurationData conf) {
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        confBuilder.setFollowRedirect(true);
        confBuilder.setRequestTimeout(conf.getRequestTimeoutMs());
        confBuilder.setConnectTimeout(connectTimeoutMs);
        confBuilder.setReadTimeout(readTimeoutMs);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setRequestTimeout(requestTimeoutMs);
        confBuilder.setIoThreadsCount(conf.getNumIoThreads());
        confBuilder.setKeepAliveStrategy(new DefaultKeepAliveStrategy(){

            @Override
            public boolean keepAlive(Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(ahcRequest, request, response);
            }
        });
        this.serviceNameResolver = new PulsarServiceNameResolver();
        if (conf != null && StringUtils.isNotBlank(conf.getServiceUrl())) {
            this.serviceNameResolver.updateServiceUrl(conf.getServiceUrl());
            if (conf.getServiceUrl().startsWith("https://")) {
                AuthenticationDataProvider authData = conf.getAuthentication().getAuthData();
                if (conf.isUseKeyStoreTls()) {
                    KeyStoreParams params = authData.hasDataForTls() ? authData.getTlsKeyStoreParams() : null;
                    SSLContext sslCtx = KeyStoreSSLContext.createClientSslContext(conf.getSslProvider(), params != null ? params.getKeyStoreType() : null, params != null ? params.getKeyStorePath() : null, params != null ? params.getKeyStorePassword() : null, conf.isTlsAllowInsecureConnection() || !conf.isTlsHostnameVerificationEnable(), conf.getTlsTrustStoreType(), conf.getTlsTrustStorePath(), conf.getTlsTrustStorePassword(), conf.getTlsCiphers(), conf.getTlsProtocols());
                    JsseSslEngineFactory sslEngineFactory = new JsseSslEngineFactory(sslCtx);
                    confBuilder.setSslEngineFactory(sslEngineFactory);
                } else {
                    SslContext sslCtx = null;
                    sslCtx = authData.hasDataForTls() ? SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection() || !conf.isTlsHostnameVerificationEnable(), conf.getTlsTrustCertsFilePath(), authData.getTlsCertificates(), authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection() || !conf.isTlsHostnameVerificationEnable(), conf.getTlsTrustCertsFilePath());
                    confBuilder.setSslContext(sslCtx);
                }
            }
        }
        this.httpClient = new DefaultAsyncHttpClient(confBuilder.build());
    }

    @Override
    public ClientResponse apply(ClientRequest jerseyRequest) {
        CompletableFuture<ClientResponse> tempFuture;
        CompletableFuture<Object> future = new CompletableFuture();
        long startTime = System.currentTimeMillis();
        Throwable lastException = null;
        HashSet<InetSocketAddress> triedAddresses = new HashSet<InetSocketAddress>();
        while (true) {
            InetSocketAddress address;
            if (triedAddresses.contains(address = this.serviceNameResolver.resolveHost())) {
                throw new ProcessingException(lastException.getMessage(), lastException);
            }
            triedAddresses.add(address);
            URI requestUri = this.replaceWithNew(address, jerseyRequest.getUri());
            jerseyRequest.setUri(requestUri);
            tempFuture = new CompletableFuture<ClientResponse>();
            try {
                this.resolveRequest(tempFuture, jerseyRequest);
                if (System.currentTimeMillis() - startTime > (long)this.httpClient.getConfig().getRequestTimeout()) {
                    throw new ProcessingException("Request timeout, the last try service url is : " + jerseyRequest.getUri().toString());
                }
            }
            catch (ExecutionException ex) {
                Throwable e;
                Throwable throwable = e = ex.getCause() == null ? ex : ex.getCause();
                if (System.currentTimeMillis() - startTime > (long)this.httpClient.getConfig().getRequestTimeout()) {
                    throw new ProcessingException(e.getMessage(), e);
                }
                lastException = e;
                continue;
            }
            catch (Exception e) {
                if (System.currentTimeMillis() - startTime > (long)this.httpClient.getConfig().getRequestTimeout()) {
                    throw new ProcessingException(e.getMessage(), e);
                }
                lastException = e;
                continue;
            }
            break;
        }
        future = tempFuture;
        return (ClientResponse)future.join();
    }

    private URI replaceWithNew(InetSocketAddress address, URI uri) {
        String originalUri = uri.toString();
        String newUri = originalUri.split(":")[0] + "://" + address.getHostName() + ":" + address.getPort() + uri.getRawPath();
        if (uri.getRawQuery() != null) {
            newUri = newUri + "?" + uri.getRawQuery();
        }
        return URI.create(newUri);
    }

    private void resolveRequest(final CompletableFuture<ClientResponse> future, ClientRequest jerseyRequest) throws InterruptedException, ExecutionException, TimeoutException {
        Future<?> resultFuture = this.apply(jerseyRequest, new AsyncConnectorCallback(){

            @Override
            public void response(ClientResponse response) {
                future.complete(response);
            }

            @Override
            public void failure(Throwable failure) {
                future.completeExceptionally(failure);
            }
        });
        Integer timeout = this.httpClient.getConfig().getRequestTimeout() / 3;
        Object result = null;
        result = timeout != null && timeout > 0 ? resultFuture.get(timeout.intValue(), TimeUnit.MILLISECONDS) : resultFuture.get();
        if (result != null && result instanceof Throwable) {
            throw new ExecutionException(result);
        }
    }

    @Override
    public Future<?> apply(final ClientRequest jerseyRequest, final AsyncConnectorCallback callback) {
        final CompletableFuture future = new CompletableFuture();
        BoundRequestBuilder builder = this.httpClient.prepare(jerseyRequest.getMethod(), jerseyRequest.getUri().toString());
        if (jerseyRequest.hasEntity()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            jerseyRequest.setStreamProvider(contentLength -> outStream);
            try {
                jerseyRequest.writeEntity();
            }
            catch (IOException e) {
                future.completeExceptionally(e);
                return future;
            }
            builder.setBody(outStream.toByteArray());
        }
        jerseyRequest.getHeaders().forEach((key, headers) -> {
            if (!"User-Agent".equals(key)) {
                builder.addHeader((CharSequence)key, (Iterable<?>)headers);
            }
        });
        builder.execute(new AsyncCompletionHandler<Response>(){

            @Override
            public Response onCompleted(Response response) throws Exception {
                ClientResponse jerseyResponse = new ClientResponse(Response.Status.fromStatusCode(response.getStatusCode()), jerseyRequest);
                response.getHeaders().forEach(e -> jerseyResponse.header((String)e.getKey(), e.getValue()));
                if (response.hasResponseBody()) {
                    jerseyResponse.setEntityStream(response.getResponseBodyAsStream());
                }
                callback.response(jerseyResponse);
                future.complete(jerseyResponse);
                return response;
            }

            @Override
            public void onThrowable(Throwable t) {
                callback.failure(t);
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    @Override
    public String getName() {
        return "Pulsar-Admin";
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            log.warn("Failed to close http client", (Throwable)e);
        }
    }

    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }
}

