/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.TopicMetadata;
import org.apache.pulsar.client.impl.MessageRouterBase;
import org.apache.pulsar.client.util.MathUtils;

public class SinglePartitionMessageRouterImpl
extends MessageRouterBase {
    private static final long serialVersionUID = 1L;
    private final int partitionIndex;

    public SinglePartitionMessageRouterImpl(int partitionIndex, HashingScheme hashingScheme) {
        super(hashingScheme);
        this.partitionIndex = partitionIndex;
    }

    public int choosePartition(Message<?> msg, TopicMetadata metadata) {
        if (msg.hasKey()) {
            return MathUtils.signSafeMod(this.hash.makeHash(msg.getKey()), metadata.numPartitions());
        }
        return this.partitionIndex;
    }
}

