/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufInputStream;
import org.apache.pulsar.shade.org.apache.commons.codec.binary.Hex;
import org.apache.pulsar.shade.org.apache.commons.lang3.SerializationException;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StructSchema<T>
extends AbstractSchema<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(StructSchema.class);
    protected final Schema schema;
    protected final SchemaInfo schemaInfo;
    protected SchemaReader<T> reader;
    protected SchemaWriter<T> writer;
    protected SchemaInfoProvider schemaInfoProvider;
    private final LoadingCache<BytesSchemaVersion, SchemaReader<T>> readerCache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<BytesSchemaVersion, SchemaReader<T>>(){

        @Override
        public SchemaReader<T> load(BytesSchemaVersion schemaVersion) {
            return StructSchema.this.loadReader(schemaVersion);
        }
    });

    protected StructSchema(SchemaInfo schemaInfo) {
        this.schema = StructSchema.parseAvroSchema(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8));
        this.schemaInfo = schemaInfo;
    }

    public Schema getAvroSchema() {
        return this.schema;
    }

    public byte[] encode(T message) {
        return this.writer.write(message);
    }

    public T decode(byte[] bytes) {
        return (T)this.reader.read(bytes);
    }

    public T decode(byte[] bytes, byte[] schemaVersion) {
        try {
            return (T)this.readerCache.get(BytesSchemaVersion.of(schemaVersion)).read(bytes);
        }
        catch (ExecutionException | AvroTypeException e) {
            if (e instanceof AvroTypeException) {
                throw new SchemaSerializationException(e);
            }
            LOG.error("Can't get generic schema for topic {} schema version {}", new Object[]{this.schemaInfoProvider.getTopicName(), Hex.encodeHexString(schemaVersion), e});
            throw new RuntimeException("Can't get generic schema for topic " + this.schemaInfoProvider.getTopicName());
        }
    }

    @Override
    public T decode(ByteBuf byteBuf) {
        return (T)this.reader.read((InputStream)new ByteBufInputStream(byteBuf));
    }

    @Override
    public T decode(ByteBuf byteBuf, byte[] schemaVersion) {
        try {
            return (T)this.readerCache.get(BytesSchemaVersion.of(schemaVersion)).read((InputStream)new ByteBufInputStream(byteBuf));
        }
        catch (ExecutionException e) {
            LOG.error("Can't get generic schema for topic {} schema version {}", new Object[]{this.schemaInfoProvider.getTopicName(), Hex.encodeHexString(schemaVersion), e});
            throw new RuntimeException("Can't get generic schema for topic " + this.schemaInfoProvider.getTopicName());
        }
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Schema createAvroSchema(SchemaDefinition schemaDefinition) {
        Class pojo = schemaDefinition.getPojo();
        if (StringUtils.isNotBlank(schemaDefinition.getJsonDef())) {
            return StructSchema.parseAvroSchema(schemaDefinition.getJsonDef());
        }
        if (pojo != null) {
            ThreadLocal validateDefaults = null;
            try {
                Field validateDefaultsField = Schema.class.getDeclaredField("VALIDATE_DEFAULTS");
                validateDefaultsField.setAccessible(true);
                validateDefaults = (ThreadLocal)validateDefaultsField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Cannot disable validation of default values", e);
            }
            boolean savedValidateDefaults = (Boolean)validateDefaults.get();
            try {
                validateDefaults.set(false);
                Schema schema = StructSchema.extractAvroSchema(schemaDefinition, pojo);
                return schema;
            }
            finally {
                validateDefaults.set(savedValidateDefaults);
            }
        }
        throw new RuntimeException("Schema definition must specify pojo class or schema json definition");
    }

    protected static Schema extractAvroSchema(SchemaDefinition schemaDefinition, Class pojo) {
        try {
            return StructSchema.parseAvroSchema(pojo.getDeclaredField("SCHEMA$").get(null).toString());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ignored) {
            return schemaDefinition.getAlwaysAllowNull() ? ReflectData.AllowNull.get().getSchema((Type)pojo) : ReflectData.get().getSchema((Type)pojo);
        }
    }

    protected static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    protected static <T> SchemaInfo parseSchemaInfo(SchemaDefinition<T> schemaDefinition, SchemaType schemaType) {
        return SchemaInfo.builder().schema(StructSchema.createAvroSchema(schemaDefinition).toString().getBytes(StandardCharsets.UTF_8)).properties(schemaDefinition.getProperties()).name("").type(schemaType).build();
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
    }

    protected abstract SchemaReader<T> loadReader(BytesSchemaVersion var1);

    protected SchemaInfo getSchemaInfoByVersion(byte[] schemaVersion) {
        try {
            return (SchemaInfo)this.schemaInfoProvider.getSchemaByVersion(schemaVersion).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SerializationException("Interrupted at fetching schema info for " + SchemaUtils.getStringSchemaVersion(schemaVersion), e);
        }
        catch (ExecutionException e) {
            throw new SerializationException("Failed at fetching schema info for " + SchemaUtils.getStringSchemaVersion(schemaVersion), e.getCause());
        }
    }

    protected void setWriter(SchemaWriter<T> writer) {
        this.writer = writer;
    }

    protected void setReader(SchemaReader<T> reader) {
        this.reader = reader;
    }

    protected SchemaReader<T> getReader() {
        return this.reader;
    }
}

