/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private final PulsarClientImpl client;
    private long txnTimeoutMs = 60000L;

    public TransactionBuilderImpl(PulsarClientImpl client) {
        this.client = client;
    }

    public TransactionBuilder withTransactionTimeout(long timeout, TimeUnit timeoutUnit) {
        this.txnTimeoutMs = timeoutUnit.toMillis(timeout);
        return this;
    }

    public CompletableFuture<Transaction> build() {
        return CompletableFuture.completedFuture(new TransactionImpl(this.client, this.txnTimeoutMs, -1L, -1L));
    }
}

