/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.Metadata;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.MetadataResolver;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectReader;

public class DefaultMetadataResolver
implements MetadataResolver {
    private final URL metadataUrl;
    private final ObjectReader objectReader;
    private Duration connectTimeout;
    private Duration readTimeout;

    public DefaultMetadataResolver(URL metadataUrl) {
        this.metadataUrl = metadataUrl;
        this.objectReader = new ObjectMapper().readerFor(Metadata.class);
    }

    public DefaultMetadataResolver withConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public DefaultMetadataResolver withReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Metadata resolve() throws IOException {
        try {
            Metadata metadata;
            URLConnection c = this.metadataUrl.openConnection();
            if (this.connectTimeout != null) {
                c.setConnectTimeout((int)this.connectTimeout.toMillis());
            }
            if (this.readTimeout != null) {
                c.setReadTimeout((int)this.readTimeout.toMillis());
            }
            c.setRequestProperty("Accept", "application/json");
            try (InputStream inputStream = c.getInputStream();){
                metadata = (Metadata)this.objectReader.readValue(inputStream);
            }
            return metadata;
        }
        catch (IOException e) {
            throw new IOException("Cannot obtain authorization metadata from " + this.metadataUrl.toString(), e);
        }
    }

    public static DefaultMetadataResolver fromIssuerUrl(URL issuerUrl) {
        return new DefaultMetadataResolver(DefaultMetadataResolver.getWellKnownMetadataUrl(issuerUrl));
    }

    public static URL getWellKnownMetadataUrl(URL issuerUrl) {
        try {
            return new URL(issuerUrl, "/.well-known/openid-configuration");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

