/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.impl.schema.generic.VersionedGenericRecord;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pulsar.shade.com.google.common.collect.Lists;

public class GenericJsonRecord
extends VersionedGenericRecord {
    private final JsonNode jn;

    GenericJsonRecord(byte[] schemaVersion, List<Field> fields, JsonNode jn) {
        super(schemaVersion, fields);
        this.jn = jn;
    }

    public JsonNode getJsonNode() {
        return this.jn;
    }

    public Object getField(String fieldName) {
        JsonNode fn = this.jn.get(fieldName);
        if (fn.isContainerNode()) {
            AtomicInteger idx = new AtomicInteger(0);
            List<Field> fields = Lists.newArrayList(fn.fieldNames()).stream().map(f -> new Field(f, idx.getAndIncrement())).collect(Collectors.toList());
            return new GenericJsonRecord(this.schemaVersion, fields, fn);
        }
        if (fn.isBoolean()) {
            return fn.asBoolean();
        }
        if (fn.isFloatingPointNumber()) {
            return fn.asDouble();
        }
        if (fn.isBigInteger()) {
            if (fn.canConvertToLong()) {
                return fn.asLong();
            }
            return fn.asText();
        }
        if (fn.isNumber()) {
            return fn.numberValue();
        }
        return fn.asText();
    }
}

