/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pulsar.client.api.BatchReceivePolicy;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessagesImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.util.ConsumerName;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.GrowableArrayBlockingQueue;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Queues;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsumerBase<T>
extends HandlerState
implements Consumer<T> {
    protected final String subscription;
    protected final ConsumerConfigurationData<T> conf;
    protected final String consumerName;
    protected final CompletableFuture<Consumer<T>> subscribeFuture;
    protected final MessageListener<T> listener;
    protected final ConsumerEventListener consumerEventListener;
    protected final ExecutorService listenerExecutor;
    final BlockingQueue<Message<T>> incomingMessages;
    protected ConcurrentOpenHashMap<MessageIdImpl, MessageIdImpl[]> unAckedChunckedMessageIdSequenceMap;
    protected final ConcurrentLinkedQueue<CompletableFuture<Message<T>>> pendingReceives;
    protected int maxReceiverQueueSize;
    protected final Schema<T> schema;
    protected final ConsumerInterceptors<T> interceptors;
    protected final BatchReceivePolicy batchReceivePolicy;
    protected ConcurrentLinkedQueue<OpBatchReceive<T>> pendingBatchReceives;
    protected static final AtomicLongFieldUpdater<ConsumerBase> INCOMING_MESSAGES_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ConsumerBase.class, "incomingMessagesSize");
    protected volatile long incomingMessagesSize = 0L;
    protected volatile Timeout batchReceiveTimeout = null;
    protected final Lock reentrantLock = new ReentrantLock();
    private static final Logger log = LoggerFactory.getLogger(ConsumerBase.class);

    protected ConsumerBase(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, int receiverQueueSize, ExecutorService listenerExecutor, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors interceptors) {
        super(client, topic);
        this.maxReceiverQueueSize = receiverQueueSize;
        this.subscription = conf.getSubscriptionName();
        this.conf = conf;
        this.consumerName = conf.getConsumerName() == null ? ConsumerName.generateRandomName() : conf.getConsumerName();
        this.subscribeFuture = subscribeFuture;
        this.listener = conf.getMessageListener();
        this.consumerEventListener = conf.getConsumerEventListener();
        this.incomingMessages = new GrowableArrayBlockingQueue<Message<T>>();
        this.unAckedChunckedMessageIdSequenceMap = new ConcurrentOpenHashMap();
        this.listenerExecutor = listenerExecutor;
        this.pendingReceives = Queues.newConcurrentLinkedQueue();
        this.schema = schema;
        this.interceptors = interceptors;
        if (conf.getBatchReceivePolicy() != null) {
            BatchReceivePolicy userBatchReceivePolicy = conf.getBatchReceivePolicy();
            if (userBatchReceivePolicy.getMaxNumMessages() > this.maxReceiverQueueSize) {
                this.batchReceivePolicy = BatchReceivePolicy.builder().maxNumMessages(this.maxReceiverQueueSize).maxNumBytes(userBatchReceivePolicy.getMaxNumBytes()).timeout((int)userBatchReceivePolicy.getTimeoutMs(), TimeUnit.MILLISECONDS).build();
                log.warn("BatchReceivePolicy maxNumMessages: {} is greater than maxReceiverQueueSize: {}, reset to maxReceiverQueueSize. batchReceivePolicy: {}", new Object[]{userBatchReceivePolicy.getMaxNumMessages(), this.maxReceiverQueueSize, this.batchReceivePolicy.toString()});
            } else if (userBatchReceivePolicy.getMaxNumMessages() <= 0 && userBatchReceivePolicy.getMaxNumBytes() <= 0) {
                this.batchReceivePolicy = BatchReceivePolicy.builder().maxNumMessages(BatchReceivePolicy.DEFAULT_POLICY.getMaxNumMessages()).maxNumBytes(BatchReceivePolicy.DEFAULT_POLICY.getMaxNumBytes()).timeout((int)userBatchReceivePolicy.getTimeoutMs(), TimeUnit.MILLISECONDS).build();
                log.warn("BatchReceivePolicy maxNumMessages: {} or maxNumBytes: {} is less than 0. Reset to DEFAULT_POLICY. batchReceivePolicy: {}", new Object[]{userBatchReceivePolicy.getMaxNumMessages(), userBatchReceivePolicy.getMaxNumBytes(), this.batchReceivePolicy.toString()});
            } else {
                this.batchReceivePolicy = conf.getBatchReceivePolicy();
            }
        } else {
            this.batchReceivePolicy = BatchReceivePolicy.DEFAULT_POLICY;
        }
        if (this.batchReceivePolicy.getTimeoutMs() > 0L) {
            this.batchReceiveTimeout = client.timer().newTimeout(this::pendingBatchReceiveTask, this.batchReceivePolicy.getTimeoutMs(), TimeUnit.MILLISECONDS);
        }
    }

    public Message<T> receive() throws PulsarClientException {
        if (this.listener != null) {
            throw new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set");
        }
        this.verifyConsumerState();
        return this.internalReceive();
    }

    public CompletableFuture<Message<T>> receiveAsync() {
        if (this.listener != null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set"));
        }
        try {
            this.verifyConsumerState();
        }
        catch (PulsarClientException e) {
            return FutureUtil.failedFuture(e);
        }
        return this.internalReceiveAsync();
    }

    protected abstract Message<T> internalReceive() throws PulsarClientException;

    protected abstract CompletableFuture<Message<T>> internalReceiveAsync();

    public Message<T> receive(int timeout, TimeUnit unit) throws PulsarClientException {
        if (this.conf.getReceiverQueueSize() == 0) {
            throw new PulsarClientException.InvalidConfigurationException("Can't use receive with timeout, if the queue size is 0");
        }
        if (this.listener != null) {
            throw new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set");
        }
        this.verifyConsumerState();
        return this.internalReceive(timeout, unit);
    }

    protected abstract Message<T> internalReceive(int var1, TimeUnit var2) throws PulsarClientException;

    public Messages<T> batchReceive() throws PulsarClientException {
        this.verifyBatchReceive();
        this.verifyConsumerState();
        return this.internalBatchReceive();
    }

    public CompletableFuture<Messages<T>> batchReceiveAsync() {
        try {
            this.verifyBatchReceive();
            this.verifyConsumerState();
            return this.internalBatchReceiveAsync();
        }
        catch (PulsarClientException e) {
            return FutureUtil.failedFuture(e);
        }
    }

    protected CompletableFuture<Message<T>> peekPendingReceive() {
        CompletableFuture<Message<T>> receivedFuture = null;
        while (receivedFuture == null && (receivedFuture = this.pendingReceives.peek()) != null) {
            if (!receivedFuture.isDone()) continue;
            CompletableFuture<Message<T>> removed = this.pendingReceives.poll();
            if (removed != receivedFuture) {
                log.error("Bug! Removed future wasn't the expected one. expected={} removed={}", receivedFuture, removed);
            }
            receivedFuture = null;
        }
        return receivedFuture;
    }

    protected CompletableFuture<Message<T>> pollPendingReceive() {
        CompletableFuture<Message<T>> receivedFuture;
        while ((receivedFuture = this.pendingReceives.poll()) != null && receivedFuture.isDone()) {
        }
        return receivedFuture;
    }

    protected void completePendingReceive(CompletableFuture<Message<T>> receivedFuture, Message<T> message) {
        this.listenerExecutor.execute(() -> {
            if (!receivedFuture.complete(message)) {
                log.warn("Race condition detected. receive future was already completed (cancelled={}) and message was dropped. message={}", (Object)receivedFuture.isCancelled(), (Object)message);
            }
        });
    }

    protected void failPendingReceives(ConcurrentLinkedQueue<CompletableFuture<Message<T>>> pendingReceives) {
        CompletableFuture<Message<T>> receiveFuture;
        while (!pendingReceives.isEmpty() && (receiveFuture = pendingReceives.poll()) != null) {
            if (receiveFuture.isDone()) continue;
            receiveFuture.completeExceptionally((Throwable)new PulsarClientException.AlreadyClosedException(String.format("The consumer which subscribes the topic %s with subscription name %s was already closed when cleaning and closing the consumers", this.topic, this.subscription)));
        }
    }

    protected void failPendingBatchReceives(ConcurrentLinkedQueue<OpBatchReceive<T>> pendingBatchReceives) {
        OpBatchReceive<T> opBatchReceive;
        while (!pendingBatchReceives.isEmpty() && (opBatchReceive = pendingBatchReceives.poll()) != null && opBatchReceive.future != null) {
            if (opBatchReceive.future.isDone()) continue;
            opBatchReceive.future.completeExceptionally((Throwable)new PulsarClientException.AlreadyClosedException(String.format("The consumer which subscribes the topic %s with subscription name %s was already closed when cleaning and closing the consumers", this.topic, this.subscription)));
        }
    }

    protected abstract Messages<T> internalBatchReceive() throws PulsarClientException;

    protected abstract CompletableFuture<Messages<T>> internalBatchReceiveAsync();

    public void acknowledge(Message<?> message) throws PulsarClientException {
        try {
            this.acknowledge(message.getMessageId());
        }
        catch (NullPointerException npe) {
            throw new PulsarClientException.InvalidMessageException(npe.getMessage());
        }
    }

    public void acknowledge(MessageId messageId) throws PulsarClientException {
        try {
            this.acknowledgeAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void acknowledge(List<MessageId> messageIdList) throws PulsarClientException {
        try {
            this.acknowledgeAsync(messageIdList).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void acknowledge(Messages<?> messages) throws PulsarClientException {
        try {
            this.acknowledgeAsync(messages).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void reconsumeLater(Message<?> message, long delayTime, TimeUnit unit) throws PulsarClientException {
        if (!this.conf.isRetryEnable()) {
            throw new PulsarClientException("reconsumeLater method not support!");
        }
        try {
            this.reconsumeLaterAsync(message, delayTime, unit).get();
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
    }

    public void reconsumeLater(Messages<?> messages, long delayTime, TimeUnit unit) throws PulsarClientException {
        try {
            this.reconsumeLaterAsync(messages, delayTime, unit).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void acknowledgeCumulative(Message<?> message) throws PulsarClientException {
        try {
            this.acknowledgeCumulative(message.getMessageId());
        }
        catch (NullPointerException npe) {
            throw new PulsarClientException.InvalidMessageException(npe.getMessage());
        }
    }

    public void acknowledgeCumulative(MessageId messageId) throws PulsarClientException {
        try {
            this.acknowledgeCumulativeAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void reconsumeLaterCumulative(Message<?> message, long delayTime, TimeUnit unit) throws PulsarClientException {
        try {
            this.reconsumeLaterCumulativeAsync(message, delayTime, unit).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> acknowledgeAsync(Message<?> message) {
        try {
            return this.acknowledgeAsync(message.getMessageId());
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    public CompletableFuture<Void> acknowledgeAsync(Messages<?> messages) {
        try {
            messages.forEach(this::acknowledgeAsync);
            return CompletableFuture.completedFuture(null);
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    public CompletableFuture<Void> acknowledgeAsync(List<MessageId> messageIdList) {
        return this.doAcknowledgeWithTxn(messageIdList, PulsarApi.CommandAck.AckType.Individual, Collections.emptyMap(), null);
    }

    public CompletableFuture<Void> reconsumeLaterAsync(Message<?> message, long delayTime, TimeUnit unit) {
        if (!this.conf.isRetryEnable()) {
            return FutureUtil.failedFuture(new PulsarClientException("reconsumeLater method not support!"));
        }
        try {
            return this.doReconsumeLater(message, PulsarApi.CommandAck.AckType.Individual, Collections.emptyMap(), delayTime, unit);
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    public CompletableFuture<Void> reconsumeLaterAsync(Messages<?> messages, long delayTime, TimeUnit unit) {
        try {
            messages.forEach(message -> this.reconsumeLaterAsync((Message<?>)message, delayTime, unit));
            return CompletableFuture.completedFuture(null);
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    public CompletableFuture<Void> acknowledgeCumulativeAsync(Message<?> message) {
        try {
            return this.acknowledgeCumulativeAsync(message.getMessageId());
        }
        catch (NullPointerException npe) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException(npe.getMessage()));
        }
    }

    public CompletableFuture<Void> reconsumeLaterCumulativeAsync(Message<?> message, long delayTime, TimeUnit unit) {
        if (!this.conf.isRetryEnable()) {
            return FutureUtil.failedFuture(new PulsarClientException("reconsumeLater method not support!"));
        }
        if (!this.isCumulativeAcknowledgementAllowed(this.conf.getSubscriptionType())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Cannot use cumulative acks on a non-exclusive subscription"));
        }
        return this.doReconsumeLater(message, PulsarApi.CommandAck.AckType.Cumulative, Collections.emptyMap(), delayTime, unit);
    }

    public CompletableFuture<Void> acknowledgeAsync(MessageId messageId) {
        return this.acknowledgeAsync(messageId, null);
    }

    public CompletableFuture<Void> acknowledgeAsync(MessageId messageId, Transaction txn) {
        TransactionImpl txnImpl = null;
        if (null != txn) {
            Preconditions.checkArgument(txn instanceof TransactionImpl);
            txnImpl = (TransactionImpl)txn;
        }
        return this.doAcknowledgeWithTxn(messageId, PulsarApi.CommandAck.AckType.Individual, Collections.emptyMap(), txnImpl);
    }

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId messageId) {
        return this.acknowledgeCumulativeAsync(messageId, null);
    }

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId messageId, Transaction txn) {
        if (!this.isCumulativeAcknowledgementAllowed(this.conf.getSubscriptionType())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Cannot use cumulative acks on a non-exclusive/non-failover subscription"));
        }
        TransactionImpl txnImpl = null;
        if (null != txn) {
            Preconditions.checkArgument(txn instanceof TransactionImpl);
            txnImpl = (TransactionImpl)txn;
        }
        return this.doAcknowledgeWithTxn(messageId, PulsarApi.CommandAck.AckType.Cumulative, Collections.emptyMap(), txnImpl);
    }

    public void negativeAcknowledge(Message<?> message) {
        this.negativeAcknowledge(message.getMessageId());
    }

    protected CompletableFuture<Void> doAcknowledgeWithTxn(List<MessageId> messageIdList, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txn) {
        CompletionStage<Void> ackFuture;
        if (txn != null) {
            ackFuture = txn.registerAckedTopic(this.getTopic(), this.subscription).thenCompose(ignored -> this.doAcknowledge(messageIdList, ackType, properties, txn));
            txn.registerAckOp((CompletableFuture<Void>)ackFuture);
        } else {
            ackFuture = this.doAcknowledge(messageIdList, ackType, properties, txn);
        }
        return ackFuture;
    }

    protected CompletableFuture<Void> doAcknowledgeWithTxn(MessageId messageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txn) {
        if (txn != null && this instanceof ConsumerImpl) {
            if (ackType == PulsarApi.CommandAck.AckType.Cumulative) {
                txn.registerCumulativeAckConsumer((ConsumerImpl)this);
            }
            CompletionStage ackFuture = txn.registerAckedTopic(this.getTopic(), this.subscription).thenCompose(ignored -> this.doAcknowledge(messageId, ackType, properties, txn));
            txn.registerAckOp((CompletableFuture<Void>)ackFuture);
            return ackFuture;
        }
        CompletableFuture<Void> ackFuture = this.doAcknowledge(messageId, ackType, properties, txn);
        return ackFuture;
    }

    protected abstract CompletableFuture<Void> doAcknowledge(MessageId var1, PulsarApi.CommandAck.AckType var2, Map<String, Long> var3, TransactionImpl var4);

    protected abstract CompletableFuture<Void> doAcknowledge(List<MessageId> var1, PulsarApi.CommandAck.AckType var2, Map<String, Long> var3, TransactionImpl var4);

    protected abstract CompletableFuture<Void> doReconsumeLater(Message<?> var1, PulsarApi.CommandAck.AckType var2, Map<String, Long> var3, long var4, TimeUnit var6);

    public void negativeAcknowledge(Messages<?> messages) {
        messages.forEach(this::negativeAcknowledge);
    }

    public void unsubscribe() throws PulsarClientException {
        try {
            this.unsubscribeAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public abstract CompletableFuture<Void> unsubscribeAsync();

    public void close() throws PulsarClientException {
        try {
            this.closeAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public abstract CompletableFuture<Void> closeAsync();

    public MessageId getLastMessageId() throws PulsarClientException {
        try {
            return this.getLastMessageIdAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public abstract CompletableFuture<MessageId> getLastMessageIdAsync();

    private boolean isCumulativeAcknowledgementAllowed(SubscriptionType type) {
        return SubscriptionType.Shared != type && SubscriptionType.Key_Shared != type;
    }

    protected PulsarApi.CommandSubscribe.SubType getSubType() {
        SubscriptionType type = this.conf.getSubscriptionType();
        switch (type) {
            case Exclusive: {
                return PulsarApi.CommandSubscribe.SubType.Exclusive;
            }
            case Shared: {
                return PulsarApi.CommandSubscribe.SubType.Shared;
            }
            case Failover: {
                return PulsarApi.CommandSubscribe.SubType.Failover;
            }
            case Key_Shared: {
                return PulsarApi.CommandSubscribe.SubType.Key_Shared;
            }
        }
        return null;
    }

    public abstract int getAvailablePermits();

    public abstract int numMessagesInQueue();

    public CompletableFuture<Consumer<T>> subscribeFuture() {
        return this.subscribeFuture;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    protected abstract void redeliverUnacknowledgedMessages(Set<MessageId> var1);

    public String toString() {
        return "ConsumerBase{subscription='" + this.subscription + '\'' + ", consumerName='" + this.consumerName + '\'' + ", topic='" + this.topic + '\'' + '}';
    }

    protected void setMaxReceiverQueueSize(int newSize) {
        this.maxReceiverQueueSize = newSize;
    }

    protected Message<T> beforeConsume(Message<T> message) {
        if (this.interceptors != null) {
            return this.interceptors.beforeConsume(this, message);
        }
        return message;
    }

    protected void onAcknowledge(MessageId messageId, Throwable exception) {
        if (this.interceptors != null) {
            this.interceptors.onAcknowledge(this, messageId, exception);
        }
    }

    protected void onAcknowledgeCumulative(MessageId messageId, Throwable exception) {
        if (this.interceptors != null) {
            this.interceptors.onAcknowledgeCumulative(this, messageId, exception);
        }
    }

    protected void onNegativeAcksSend(Set<MessageId> messageIds) {
        if (this.interceptors != null) {
            this.interceptors.onNegativeAcksSend(this, messageIds);
        }
    }

    protected void onAckTimeoutSend(Set<MessageId> messageIds) {
        if (this.interceptors != null) {
            this.interceptors.onAckTimeoutSend(this, messageIds);
        }
    }

    protected boolean canEnqueueMessage(Message<T> message) {
        return true;
    }

    protected boolean enqueueMessageAndCheckBatchReceive(Message<T> message) {
        if (this.canEnqueueMessage(message) && this.incomingMessages.offer(message)) {
            INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, message.getData() == null ? 0L : (long)message.getData().length);
        }
        return this.hasEnoughMessagesForBatchReceive();
    }

    protected boolean hasEnoughMessagesForBatchReceive() {
        if (this.batchReceivePolicy.getMaxNumMessages() <= 0 && this.batchReceivePolicy.getMaxNumBytes() <= 0) {
            return false;
        }
        return this.batchReceivePolicy.getMaxNumMessages() > 0 && this.incomingMessages.size() >= this.batchReceivePolicy.getMaxNumMessages() || this.batchReceivePolicy.getMaxNumBytes() > 0 && INCOMING_MESSAGES_SIZE_UPDATER.get(this) >= (long)this.batchReceivePolicy.getMaxNumBytes();
    }

    private void verifyConsumerState() throws PulsarClientException {
        switch (this.getState()) {
            case Ready: 
            case Connecting: {
                break;
            }
            case Closing: 
            case Closed: {
                throw new PulsarClientException.AlreadyClosedException("Consumer already closed");
            }
            case Terminated: {
                throw new PulsarClientException.AlreadyClosedException("Topic was terminated");
            }
            case Failed: 
            case Uninitialized: {
                throw new PulsarClientException.NotConnectedException();
            }
        }
    }

    private void verifyBatchReceive() throws PulsarClientException {
        if (this.listener != null) {
            throw new PulsarClientException.InvalidConfigurationException("Cannot use receive() when a listener has been set");
        }
        if (this.conf.getReceiverQueueSize() == 0) {
            throw new PulsarClientException.InvalidConfigurationException("Can't use batch receive, if the queue size is 0");
        }
    }

    protected void notifyPendingBatchReceivedCallBack() {
        OpBatchReceive<T> opBatchReceive = this.pollNextBatchReceive();
        if (opBatchReceive == null) {
            return;
        }
        try {
            this.reentrantLock.lock();
            this.notifyPendingBatchReceivedCallBack(opBatchReceive);
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    private OpBatchReceive<T> peekNextBatchReceive() {
        OpBatchReceive<T> opBatchReceive = null;
        while (opBatchReceive == null) {
            opBatchReceive = this.pendingBatchReceives.peek();
            if (opBatchReceive == null) {
                return null;
            }
            if (opBatchReceive.future != null && !opBatchReceive.future.isDone()) continue;
            OpBatchReceive<T> removed = this.pendingBatchReceives.poll();
            if (removed != opBatchReceive) {
                log.error("Bug: Removed entry wasn't the expected one. expected={}, removed={}", opBatchReceive, removed);
            }
            opBatchReceive = null;
        }
        return opBatchReceive;
    }

    private OpBatchReceive<T> pollNextBatchReceive() {
        OpBatchReceive<T> opBatchReceive = null;
        while (opBatchReceive == null) {
            opBatchReceive = this.pendingBatchReceives.poll();
            if (opBatchReceive == null) {
                return null;
            }
            if (opBatchReceive.future != null && !opBatchReceive.future.isDone()) continue;
            opBatchReceive = null;
        }
        return opBatchReceive;
    }

    protected final void notifyPendingBatchReceivedCallBack(OpBatchReceive<T> opBatchReceive) {
        MessagesImpl<T> messages = this.getNewMessagesImpl();
        Message msgPeeked = (Message)this.incomingMessages.peek();
        while (msgPeeked != null && messages.canAdd(msgPeeked)) {
            Message msg = (Message)this.incomingMessages.poll();
            if (msg != null) {
                this.messageProcessed(msg);
                Message<T> interceptMsg = this.beforeConsume(msg);
                messages.add(interceptMsg);
            }
            msgPeeked = (Message)this.incomingMessages.peek();
        }
        this.completePendingBatchReceive(opBatchReceive.future, messages);
    }

    protected void completePendingBatchReceive(CompletableFuture<Messages<T>> future, Messages<T> messages) {
        if (!future.complete(messages)) {
            log.warn("Race condition detected. batch receive future was already completed (cancelled={}) and messages were dropped. messages={}", (Object)future.isCancelled(), messages);
        }
    }

    protected abstract void messageProcessed(Message<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pendingBatchReceiveTask(Timeout timeout) throws Exception {
        if (timeout.isCancelled()) {
            return;
        }
        ConsumerBase consumerBase = this;
        synchronized (consumerBase) {
            if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
                return;
            }
            if (this.pendingBatchReceives == null) {
                this.pendingBatchReceives = Queues.newConcurrentLinkedQueue();
            }
            OpBatchReceive<T> firstOpBatchReceive = this.peekNextBatchReceive();
            long timeToWaitMs = this.batchReceivePolicy.getTimeoutMs();
            while (firstOpBatchReceive != null) {
                long diff = this.batchReceivePolicy.getTimeoutMs() - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - firstOpBatchReceive.createdAt);
                if (diff <= 0L) {
                    OpBatchReceive<T> op = this.pollNextBatchReceive();
                    if (op != null) {
                        this.completeOpBatchReceive(op);
                    }
                    firstOpBatchReceive = this.peekNextBatchReceive();
                    continue;
                }
                timeToWaitMs = diff;
                break;
            }
            this.batchReceiveTimeout = this.client.timer().newTimeout(this::pendingBatchReceiveTask, timeToWaitMs, TimeUnit.MILLISECONDS);
        }
    }

    protected MessagesImpl<T> getNewMessagesImpl() {
        return new MessagesImpl(this.batchReceivePolicy.getMaxNumMessages(), this.batchReceivePolicy.getMaxNumBytes());
    }

    protected boolean hasPendingBatchReceive() {
        return this.pendingBatchReceives != null && this.peekNextBatchReceive() != null;
    }

    protected abstract void completeOpBatchReceive(OpBatchReceive<T> var1);

    protected static final class OpBatchReceive<T> {
        final CompletableFuture<Messages<T>> future;
        final long createdAt;

        private OpBatchReceive(CompletableFuture<Messages<T>> future) {
            this.future = future;
            this.createdAt = System.nanoTime();
        }

        static <T> OpBatchReceive<T> of(CompletableFuture<Messages<T>> future) {
            return new OpBatchReceive<T>(future);
        }
    }

    static enum ConsumerType {
        PARTITIONED,
        NON_PARTITIONED;

    }
}

