/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TransactionMetaStoreHandler;
import org.apache.pulsar.client.util.MathUtils;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentLongHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCoordinatorClientImpl
implements TransactionCoordinatorClient {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionCoordinatorClientImpl.class);
    private final PulsarClientImpl pulsarClient;
    private TransactionMetaStoreHandler[] handlers;
    private ConcurrentLongHashMap<TransactionMetaStoreHandler> handlerMap = new ConcurrentLongHashMap(16, 1);
    private final AtomicLong epoch = new AtomicLong(0L);
    private static final AtomicReferenceFieldUpdater<TransactionCoordinatorClientImpl, TransactionCoordinatorClient.State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TransactionCoordinatorClientImpl.class, TransactionCoordinatorClient.State.class, "state");
    private volatile TransactionCoordinatorClient.State state = TransactionCoordinatorClient.State.NONE;

    public TransactionCoordinatorClientImpl(PulsarClient pulsarClient) {
        this.pulsarClient = (PulsarClientImpl)pulsarClient;
    }

    public void start() throws TransactionCoordinatorClientException {
        try {
            this.startAsync().get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> startAsync() {
        if (STATE_UPDATER.compareAndSet(this, TransactionCoordinatorClient.State.NONE, TransactionCoordinatorClient.State.STARTING)) {
            return this.pulsarClient.getLookup().getPartitionedTopicMetadata(TopicName.TRANSACTION_COORDINATOR_ASSIGN).thenCompose(partitionMeta -> {
                ArrayList connectFutureList = new ArrayList();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Transaction meta store assign partition is {}.", (Object)partitionMeta.partitions);
                }
                if (partitionMeta.partitions > 0) {
                    this.handlers = new TransactionMetaStoreHandler[partitionMeta.partitions];
                    for (int i = 0; i < partitionMeta.partitions; ++i) {
                        TransactionMetaStoreHandler handler;
                        CompletableFuture<Void> connectFuture = new CompletableFuture<Void>();
                        connectFutureList.add(connectFuture);
                        this.handlers[i] = handler = new TransactionMetaStoreHandler(i, this.pulsarClient, this.getTCAssignTopicName(i), connectFuture);
                        this.handlerMap.put(i, handler);
                    }
                } else {
                    TransactionMetaStoreHandler handler;
                    this.handlers = new TransactionMetaStoreHandler[1];
                    CompletableFuture<Void> connectFuture = new CompletableFuture<Void>();
                    connectFutureList.add(connectFuture);
                    this.handlers[0] = handler = new TransactionMetaStoreHandler(0L, this.pulsarClient, this.getTCAssignTopicName(-1), connectFuture);
                    this.handlerMap.put(0L, handler);
                }
                STATE_UPDATER.set(this, TransactionCoordinatorClient.State.READY);
                return FutureUtil.waitForAll(connectFutureList);
            });
        }
        return FutureUtil.failedFuture((Throwable)new TransactionCoordinatorClientException.CoordinatorClientStateException("Can not start while current state is " + this.state));
    }

    private String getTCAssignTopicName(int partition) {
        if (partition >= 0) {
            return TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString() + "-partition-" + partition;
        }
        return TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString();
    }

    public void close() throws TransactionCoordinatorClientException {
        try {
            this.closeAsync().get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (this.getState() == TransactionCoordinatorClient.State.CLOSING || this.getState() == TransactionCoordinatorClient.State.CLOSED) {
            LOG.warn("The transaction meta store is closing or closed, doing nothing.");
            result.complete(null);
        } else {
            for (TransactionMetaStoreHandler handler : this.handlers) {
                try {
                    handler.close();
                }
                catch (IOException e) {
                    LOG.warn("Close transaction meta store handler error", (Throwable)e);
                }
            }
            this.handlers = null;
            result.complete(null);
        }
        return result;
    }

    public TxnID newTransaction() throws TransactionCoordinatorClientException {
        try {
            return this.newTransactionAsync().get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<TxnID> newTransactionAsync() {
        return this.newTransactionAsync(60000L, TimeUnit.MILLISECONDS);
    }

    public TxnID newTransaction(long timeout, TimeUnit unit) throws TransactionCoordinatorClientException {
        try {
            return this.newTransactionAsync(timeout, unit).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<TxnID> newTransactionAsync(long timeout, TimeUnit unit) {
        return this.nextHandler().newTransactionAsync(timeout, unit);
    }

    public void addPublishPartitionToTxn(TxnID txnID, List<String> partitions) throws TransactionCoordinatorClientException {
        try {
            this.addPublishPartitionToTxnAsync(txnID, partitions).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> addPublishPartitionToTxnAsync(TxnID txnID, List<String> partitions) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture((Throwable)new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        return handler.addPublishPartitionToTxnAsync(txnID, partitions);
    }

    public void addSubscriptionToTxn(TxnID txnID, String topic, String subscription) throws TransactionCoordinatorClientException {
        try {
            this.addSubscriptionToTxnAsync(txnID, topic, subscription).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> addSubscriptionToTxnAsync(TxnID txnID, String topic, String subscription) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture((Throwable)new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        PulsarApi.Subscription sub = PulsarApi.Subscription.newBuilder().setTopic(topic).setSubscription(subscription).build();
        return handler.addSubscriptionToTxn(txnID, Collections.singletonList(sub));
    }

    public void commit(TxnID txnID, List<MessageId> messageIdList) throws TransactionCoordinatorClientException {
        try {
            this.commitAsync(txnID, messageIdList).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> commitAsync(TxnID txnID, List<MessageId> messageIdList) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture((Throwable)new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        return handler.commitAsync(txnID, messageIdList);
    }

    public void abort(TxnID txnID, List<MessageId> messageIdList) throws TransactionCoordinatorClientException {
        try {
            this.abortAsync(txnID, messageIdList).get();
        }
        catch (Exception e) {
            throw TransactionCoordinatorClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> abortAsync(TxnID txnID, List<MessageId> messageIdList) {
        TransactionMetaStoreHandler handler = this.handlerMap.get(txnID.getMostSigBits());
        if (handler == null) {
            return FutureUtil.failedFuture((Throwable)new TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException(txnID.getMostSigBits()));
        }
        return handler.abortAsync(txnID, messageIdList);
    }

    public TransactionCoordinatorClient.State getState() {
        return this.state;
    }

    private TransactionMetaStoreHandler nextHandler() {
        int index = MathUtils.signSafeMod(this.epoch.incrementAndGet(), this.handlers.length);
        return this.handlers[index];
    }
}

