/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;

public class TopicMessageIdImpl
implements MessageId {
    private final String topicPartitionName;
    private final String topicName;
    private final MessageId messageId;

    public TopicMessageIdImpl(String topicPartitionName, String topicName, MessageId messageId) {
        this.messageId = messageId;
        this.topicPartitionName = topicPartitionName;
        this.topicName = topicName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getTopicPartitionName() {
        return this.topicPartitionName;
    }

    public MessageId getInnerMessageId() {
        return this.messageId;
    }

    public byte[] toByteArray() {
        return this.messageId.toByteArray();
    }

    public int hashCode() {
        return Objects.hash(this.topicPartitionName, this.messageId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TopicMessageIdImpl)) {
            return false;
        }
        TopicMessageIdImpl other = (TopicMessageIdImpl)obj;
        return Objects.equals(this.topicPartitionName, other.topicPartitionName) && Objects.equals(this.messageId, other.messageId);
    }

    public int compareTo(MessageId o) {
        return this.messageId.compareTo((Object)o);
    }
}

