/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;

public class NettySslContextBuilder
extends SslContextAutoRefreshBuilder<SslContext> {
    private volatile SslContext sslNettyContext;

    public NettySslContextBuilder(boolean allowInsecure, String trustCertsFilePath, String certificateFilePath, String keyFilePath, Set<String> ciphers, Set<String> protocols, boolean requireTrustedClientCertOnConnect, long delayInSeconds) throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        super(allowInsecure, trustCertsFilePath, certificateFilePath, keyFilePath, ciphers, protocols, requireTrustedClientCertOnConnect, delayInSeconds);
    }

    @Override
    public synchronized SslContext update() throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        this.sslNettyContext = SecurityUtility.createNettySslContextForServer(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName(), this.tlsCiphers, this.tlsProtocols, this.tlsRequireTrustedClientCertOnConnect);
        return this.sslNettyContext;
    }

    @Override
    public SslContext getSslContext() {
        return this.sslNettyContext;
    }
}

