/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SslContextAutoRefreshBuilder<T> {
    protected final boolean tlsAllowInsecureConnection;
    protected final FileModifiedTimeUpdater tlsTrustCertsFilePath;
    protected final FileModifiedTimeUpdater tlsCertificateFilePath;
    protected final FileModifiedTimeUpdater tlsKeyFilePath;
    protected final Set<String> tlsCiphers;
    protected final Set<String> tlsProtocols;
    protected final boolean tlsRequireTrustedClientCertOnConnect;
    protected final long refreshTime;
    protected long lastRefreshTime;
    private static final Logger LOG = LoggerFactory.getLogger(SslContextAutoRefreshBuilder.class);

    public SslContextAutoRefreshBuilder(boolean allowInsecure, String trustCertsFilePath, String certificateFilePath, String keyFilePath, Set<String> ciphers, Set<String> protocols, boolean requireTrustedClientCertOnConnect, long certRefreshInSec) throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.tlsCertificateFilePath = new FileModifiedTimeUpdater(certificateFilePath);
        this.tlsKeyFilePath = new FileModifiedTimeUpdater(keyFilePath);
        this.tlsCiphers = ciphers;
        this.tlsProtocols = protocols;
        this.tlsRequireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
        this.refreshTime = TimeUnit.SECONDS.toMillis(certRefreshInSec);
        this.lastRefreshTime = -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certs will be refreshed every {} seconds", (Object)certRefreshInSec);
        }
    }

    protected abstract T update() throws GeneralSecurityException, IOException;

    protected abstract T getSslContext();

    public T get() {
        T ctx = this.getSslContext();
        if (ctx == null) {
            try {
                this.update();
                this.lastRefreshTime = System.currentTimeMillis();
                return this.getSslContext();
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.error("Execption while trying to refresh ssl Context {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            long now = System.currentTimeMillis();
            if ((this.refreshTime <= 0L || now > this.lastRefreshTime + this.refreshTime) && (this.tlsTrustCertsFilePath.checkAndRefresh() || this.tlsCertificateFilePath.checkAndRefresh() || this.tlsKeyFilePath.checkAndRefresh())) {
                try {
                    ctx = this.update();
                    this.lastRefreshTime = now;
                }
                catch (IOException | GeneralSecurityException e) {
                    LOG.error("Execption while trying to refresh ssl Context {} ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return ctx;
    }
}

