/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonPropertyOrder(value={"receivedTotal", "processedSuccessfullyTotal", "systemExceptionsTotal", "userExceptionsTotal", "avgProcessLatency", "1min", "lastInvocation", "instances"})
public class FunctionStats {
    public long receivedTotal;
    public long processedSuccessfullyTotal;
    public long systemExceptionsTotal;
    public long userExceptionsTotal;
    public Double avgProcessLatency;
    @JsonProperty(value="1min")
    public FunctionInstanceStats.FunctionInstanceStatsDataBase oneMin = new FunctionInstanceStats.FunctionInstanceStatsDataBase();
    public Long lastInvocation;
    public List<FunctionInstanceStats> instances = new LinkedList<FunctionInstanceStats>();

    public void addInstance(FunctionInstanceStats functionInstanceStats) {
        this.instances.add(functionInstanceStats);
    }

    public FunctionStats calculateOverall() {
        int nonNullInstances = 0;
        int nonNullInstancesOneMin = 0;
        for (FunctionInstanceStats functionInstanceStats : this.instances) {
            FunctionInstanceStats.FunctionInstanceStatsData functionInstanceStatsData = functionInstanceStats.getMetrics();
            this.receivedTotal += functionInstanceStatsData.receivedTotal;
            this.processedSuccessfullyTotal += functionInstanceStatsData.processedSuccessfullyTotal;
            this.systemExceptionsTotal += functionInstanceStatsData.systemExceptionsTotal;
            this.userExceptionsTotal += functionInstanceStatsData.userExceptionsTotal;
            if (functionInstanceStatsData.avgProcessLatency != null) {
                if (this.avgProcessLatency == null) {
                    this.avgProcessLatency = 0.0;
                }
                this.avgProcessLatency = this.avgProcessLatency + functionInstanceStatsData.avgProcessLatency;
                ++nonNullInstances;
            }
            this.oneMin.receivedTotal += functionInstanceStatsData.oneMin.receivedTotal;
            this.oneMin.processedSuccessfullyTotal += functionInstanceStatsData.oneMin.processedSuccessfullyTotal;
            this.oneMin.systemExceptionsTotal += functionInstanceStatsData.oneMin.systemExceptionsTotal;
            this.oneMin.userExceptionsTotal += functionInstanceStatsData.oneMin.userExceptionsTotal;
            if (functionInstanceStatsData.oneMin.avgProcessLatency != null) {
                if (this.oneMin.avgProcessLatency == null) {
                    this.oneMin.avgProcessLatency = 0.0;
                }
                FunctionInstanceStats.FunctionInstanceStatsDataBase functionInstanceStatsDataBase = this.oneMin;
                Double.valueOf(functionInstanceStatsDataBase.avgProcessLatency + functionInstanceStatsData.oneMin.avgProcessLatency);
                functionInstanceStatsDataBase.avgProcessLatency = functionInstanceStatsDataBase.avgProcessLatency;
                ++nonNullInstancesOneMin;
            }
            if (functionInstanceStatsData.lastInvocation == null || this.lastInvocation != null && functionInstanceStatsData.lastInvocation <= this.lastInvocation) continue;
            this.lastInvocation = functionInstanceStatsData.lastInvocation;
        }
        this.avgProcessLatency = nonNullInstances > 0 ? Double.valueOf(this.avgProcessLatency / (double)nonNullInstances) : null;
        this.oneMin.avgProcessLatency = nonNullInstancesOneMin > 0 ? Double.valueOf(this.oneMin.avgProcessLatency / (double)nonNullInstancesOneMin) : null;
        return this;
    }

    public static FunctionStats decode(String json) throws IOException {
        return ObjectMapperFactory.getThreadLocal().readValue(json, FunctionStats.class);
    }

    public long getReceivedTotal() {
        return this.receivedTotal;
    }

    public long getProcessedSuccessfullyTotal() {
        return this.processedSuccessfullyTotal;
    }

    public long getSystemExceptionsTotal() {
        return this.systemExceptionsTotal;
    }

    public long getUserExceptionsTotal() {
        return this.userExceptionsTotal;
    }

    public Double getAvgProcessLatency() {
        return this.avgProcessLatency;
    }

    public FunctionInstanceStats.FunctionInstanceStatsDataBase getOneMin() {
        return this.oneMin;
    }

    public Long getLastInvocation() {
        return this.lastInvocation;
    }

    public List<FunctionInstanceStats> getInstances() {
        return this.instances;
    }

    public void setReceivedTotal(long receivedTotal) {
        this.receivedTotal = receivedTotal;
    }

    public void setProcessedSuccessfullyTotal(long processedSuccessfullyTotal) {
        this.processedSuccessfullyTotal = processedSuccessfullyTotal;
    }

    public void setSystemExceptionsTotal(long systemExceptionsTotal) {
        this.systemExceptionsTotal = systemExceptionsTotal;
    }

    public void setUserExceptionsTotal(long userExceptionsTotal) {
        this.userExceptionsTotal = userExceptionsTotal;
    }

    public void setAvgProcessLatency(Double avgProcessLatency) {
        this.avgProcessLatency = avgProcessLatency;
    }

    @JsonProperty(value="1min")
    public void setOneMin(FunctionInstanceStats.FunctionInstanceStatsDataBase oneMin) {
        this.oneMin = oneMin;
    }

    public void setLastInvocation(Long lastInvocation) {
        this.lastInvocation = lastInvocation;
    }

    public void setInstances(List<FunctionInstanceStats> instances) {
        this.instances = instances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionStats)) {
            return false;
        }
        FunctionStats other = (FunctionStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReceivedTotal() != other.getReceivedTotal()) {
            return false;
        }
        if (this.getProcessedSuccessfullyTotal() != other.getProcessedSuccessfullyTotal()) {
            return false;
        }
        if (this.getSystemExceptionsTotal() != other.getSystemExceptionsTotal()) {
            return false;
        }
        if (this.getUserExceptionsTotal() != other.getUserExceptionsTotal()) {
            return false;
        }
        Double this$avgProcessLatency = this.getAvgProcessLatency();
        Double other$avgProcessLatency = other.getAvgProcessLatency();
        if (this$avgProcessLatency == null ? other$avgProcessLatency != null : !((Object)this$avgProcessLatency).equals(other$avgProcessLatency)) {
            return false;
        }
        Long this$lastInvocation = this.getLastInvocation();
        Long other$lastInvocation = other.getLastInvocation();
        if (this$lastInvocation == null ? other$lastInvocation != null : !((Object)this$lastInvocation).equals(other$lastInvocation)) {
            return false;
        }
        FunctionInstanceStats.FunctionInstanceStatsDataBase this$oneMin = this.getOneMin();
        FunctionInstanceStats.FunctionInstanceStatsDataBase other$oneMin = other.getOneMin();
        if (this$oneMin == null ? other$oneMin != null : !((Object)this$oneMin).equals(other$oneMin)) {
            return false;
        }
        List<FunctionInstanceStats> this$instances = this.getInstances();
        List<FunctionInstanceStats> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $receivedTotal = this.getReceivedTotal();
        result = result * 59 + (int)($receivedTotal >>> 32 ^ $receivedTotal);
        long $processedSuccessfullyTotal = this.getProcessedSuccessfullyTotal();
        result = result * 59 + (int)($processedSuccessfullyTotal >>> 32 ^ $processedSuccessfullyTotal);
        long $systemExceptionsTotal = this.getSystemExceptionsTotal();
        result = result * 59 + (int)($systemExceptionsTotal >>> 32 ^ $systemExceptionsTotal);
        long $userExceptionsTotal = this.getUserExceptionsTotal();
        result = result * 59 + (int)($userExceptionsTotal >>> 32 ^ $userExceptionsTotal);
        Double $avgProcessLatency = this.getAvgProcessLatency();
        result = result * 59 + ($avgProcessLatency == null ? 43 : ((Object)$avgProcessLatency).hashCode());
        Long $lastInvocation = this.getLastInvocation();
        result = result * 59 + ($lastInvocation == null ? 43 : ((Object)$lastInvocation).hashCode());
        FunctionInstanceStats.FunctionInstanceStatsDataBase $oneMin = this.getOneMin();
        result = result * 59 + ($oneMin == null ? 43 : ((Object)$oneMin).hashCode());
        List<FunctionInstanceStats> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        return result;
    }

    public String toString() {
        return "FunctionStats(receivedTotal=" + this.getReceivedTotal() + ", processedSuccessfullyTotal=" + this.getProcessedSuccessfullyTotal() + ", systemExceptionsTotal=" + this.getSystemExceptionsTotal() + ", userExceptionsTotal=" + this.getUserExceptionsTotal() + ", avgProcessLatency=" + this.getAvgProcessLatency() + ", oneMin=" + this.getOneMin() + ", lastInvocation=" + this.getLastInvocation() + ", instances=" + this.getInstances() + ")";
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonPropertyOrder(value={"instanceId", "metrics"})
    public static class FunctionInstanceStats {
        public int instanceId;
        public FunctionInstanceStatsData metrics = new FunctionInstanceStatsData();

        public int getInstanceId() {
            return this.instanceId;
        }

        public FunctionInstanceStatsData getMetrics() {
            return this.metrics;
        }

        public void setInstanceId(int instanceId) {
            this.instanceId = instanceId;
        }

        public void setMetrics(FunctionInstanceStatsData metrics) {
            this.metrics = metrics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionInstanceStats)) {
                return false;
            }
            FunctionInstanceStats other = (FunctionInstanceStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getInstanceId() != other.getInstanceId()) {
                return false;
            }
            FunctionInstanceStatsData this$metrics = this.getMetrics();
            FunctionInstanceStatsData other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionInstanceStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getInstanceId();
            FunctionInstanceStatsData $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionStats.FunctionInstanceStats(instanceId=" + this.getInstanceId() + ", metrics=" + this.getMetrics() + ")";
        }

        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        @JsonPropertyOrder(value={"receivedTotal", "processedSuccessfullyTotal", "systemExceptionsTotal", "userExceptionsTotal", "avgProcessLatency", "1min", "lastInvocation", "userMetrics"})
        public static class FunctionInstanceStatsData
        extends FunctionInstanceStatsDataBase {
            @JsonProperty(value="1min")
            public FunctionInstanceStatsDataBase oneMin = new FunctionInstanceStatsDataBase();
            public Long lastInvocation;
            public Map<String, Double> userMetrics = new HashMap<String, Double>();

            public FunctionInstanceStatsDataBase getOneMin() {
                return this.oneMin;
            }

            public Long getLastInvocation() {
                return this.lastInvocation;
            }

            public Map<String, Double> getUserMetrics() {
                return this.userMetrics;
            }

            @JsonProperty(value="1min")
            public void setOneMin(FunctionInstanceStatsDataBase oneMin) {
                this.oneMin = oneMin;
            }

            public void setLastInvocation(Long lastInvocation) {
                this.lastInvocation = lastInvocation;
            }

            public void setUserMetrics(Map<String, Double> userMetrics) {
                this.userMetrics = userMetrics;
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FunctionInstanceStatsData)) {
                    return false;
                }
                FunctionInstanceStatsData other = (FunctionInstanceStatsData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$lastInvocation = this.getLastInvocation();
                Long other$lastInvocation = other.getLastInvocation();
                if (this$lastInvocation == null ? other$lastInvocation != null : !((Object)this$lastInvocation).equals(other$lastInvocation)) {
                    return false;
                }
                FunctionInstanceStatsDataBase this$oneMin = this.getOneMin();
                FunctionInstanceStatsDataBase other$oneMin = other.getOneMin();
                if (this$oneMin == null ? other$oneMin != null : !((Object)this$oneMin).equals(other$oneMin)) {
                    return false;
                }
                Map<String, Double> this$userMetrics = this.getUserMetrics();
                Map<String, Double> other$userMetrics = other.getUserMetrics();
                return !(this$userMetrics == null ? other$userMetrics != null : !((Object)this$userMetrics).equals(other$userMetrics));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof FunctionInstanceStatsData;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $lastInvocation = this.getLastInvocation();
                result = result * 59 + ($lastInvocation == null ? 43 : ((Object)$lastInvocation).hashCode());
                FunctionInstanceStatsDataBase $oneMin = this.getOneMin();
                result = result * 59 + ($oneMin == null ? 43 : ((Object)$oneMin).hashCode());
                Map<String, Double> $userMetrics = this.getUserMetrics();
                result = result * 59 + ($userMetrics == null ? 43 : ((Object)$userMetrics).hashCode());
                return result;
            }

            @Override
            public String toString() {
                return "FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData(oneMin=" + this.getOneMin() + ", lastInvocation=" + this.getLastInvocation() + ", userMetrics=" + this.getUserMetrics() + ")";
            }
        }

        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        @JsonPropertyOrder(value={"receivedTotal", "processedSuccessfullyTotal", "systemExceptionsTotal", "userExceptionsTotal", "avgProcessLatency"})
        public static class FunctionInstanceStatsDataBase {
            public long receivedTotal;
            public long processedSuccessfullyTotal;
            public long systemExceptionsTotal;
            public long userExceptionsTotal;
            public Double avgProcessLatency;

            public long getReceivedTotal() {
                return this.receivedTotal;
            }

            public long getProcessedSuccessfullyTotal() {
                return this.processedSuccessfullyTotal;
            }

            public long getSystemExceptionsTotal() {
                return this.systemExceptionsTotal;
            }

            public long getUserExceptionsTotal() {
                return this.userExceptionsTotal;
            }

            public Double getAvgProcessLatency() {
                return this.avgProcessLatency;
            }

            public void setReceivedTotal(long receivedTotal) {
                this.receivedTotal = receivedTotal;
            }

            public void setProcessedSuccessfullyTotal(long processedSuccessfullyTotal) {
                this.processedSuccessfullyTotal = processedSuccessfullyTotal;
            }

            public void setSystemExceptionsTotal(long systemExceptionsTotal) {
                this.systemExceptionsTotal = systemExceptionsTotal;
            }

            public void setUserExceptionsTotal(long userExceptionsTotal) {
                this.userExceptionsTotal = userExceptionsTotal;
            }

            public void setAvgProcessLatency(Double avgProcessLatency) {
                this.avgProcessLatency = avgProcessLatency;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FunctionInstanceStatsDataBase)) {
                    return false;
                }
                FunctionInstanceStatsDataBase other = (FunctionInstanceStatsDataBase)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getReceivedTotal() != other.getReceivedTotal()) {
                    return false;
                }
                if (this.getProcessedSuccessfullyTotal() != other.getProcessedSuccessfullyTotal()) {
                    return false;
                }
                if (this.getSystemExceptionsTotal() != other.getSystemExceptionsTotal()) {
                    return false;
                }
                if (this.getUserExceptionsTotal() != other.getUserExceptionsTotal()) {
                    return false;
                }
                Double this$avgProcessLatency = this.getAvgProcessLatency();
                Double other$avgProcessLatency = other.getAvgProcessLatency();
                return !(this$avgProcessLatency == null ? other$avgProcessLatency != null : !((Object)this$avgProcessLatency).equals(other$avgProcessLatency));
            }

            protected boolean canEqual(Object other) {
                return other instanceof FunctionInstanceStatsDataBase;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $receivedTotal = this.getReceivedTotal();
                result = result * 59 + (int)($receivedTotal >>> 32 ^ $receivedTotal);
                long $processedSuccessfullyTotal = this.getProcessedSuccessfullyTotal();
                result = result * 59 + (int)($processedSuccessfullyTotal >>> 32 ^ $processedSuccessfullyTotal);
                long $systemExceptionsTotal = this.getSystemExceptionsTotal();
                result = result * 59 + (int)($systemExceptionsTotal >>> 32 ^ $systemExceptionsTotal);
                long $userExceptionsTotal = this.getUserExceptionsTotal();
                result = result * 59 + (int)($userExceptionsTotal >>> 32 ^ $userExceptionsTotal);
                Double $avgProcessLatency = this.getAvgProcessLatency();
                result = result * 59 + ($avgProcessLatency == null ? 43 : ((Object)$avgProcessLatency).hashCode());
                return result;
            }

            public String toString() {
                return "FunctionStats.FunctionInstanceStats.FunctionInstanceStatsDataBase(receivedTotal=" + this.getReceivedTotal() + ", processedSuccessfullyTotal=" + this.getProcessedSuccessfullyTotal() + ", systemExceptionsTotal=" + this.getSystemExceptionsTotal() + ", userExceptionsTotal=" + this.getUserExceptionsTotal() + ", avgProcessLatency=" + this.getAvgProcessLatency() + ")";
            }
        }
    }
}

