/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.pulsar.functions.api.Record;

public interface BulkProcessor
extends Closeable {
    public void appendIndexRequest(BulkIndexRequest var1) throws IOException;

    public void appendDeleteRequest(BulkDeleteRequest var1) throws IOException;

    public void flush();

    @Override
    public void close();

    public static class BulkDeleteRequest {
        private Record record;
        private long requestId;
        private String index;
        private String documentId;

        BulkDeleteRequest(Record record, long requestId, String index, String documentId) {
            this.record = record;
            this.requestId = requestId;
            this.index = index;
            this.documentId = documentId;
        }

        public static BulkDeleteRequestBuilder builder() {
            return new BulkDeleteRequestBuilder();
        }

        public Record getRecord() {
            return this.record;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public String getIndex() {
            return this.index;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public static class BulkDeleteRequestBuilder {
            private Record record;
            private long requestId;
            private String index;
            private String documentId;

            BulkDeleteRequestBuilder() {
            }

            public BulkDeleteRequestBuilder record(Record record) {
                this.record = record;
                return this;
            }

            public BulkDeleteRequestBuilder requestId(long requestId) {
                this.requestId = requestId;
                return this;
            }

            public BulkDeleteRequestBuilder index(String index) {
                this.index = index;
                return this;
            }

            public BulkDeleteRequestBuilder documentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            public BulkDeleteRequest build() {
                return new BulkDeleteRequest(this.record, this.requestId, this.index, this.documentId);
            }

            public String toString() {
                return "BulkProcessor.BulkDeleteRequest.BulkDeleteRequestBuilder(record=" + String.valueOf(this.record) + ", requestId=" + this.requestId + ", index=" + this.index + ", documentId=" + this.documentId + ")";
            }
        }
    }

    public static class BulkIndexRequest {
        private Record record;
        private long requestId;
        private String index;
        private String documentId;
        private String documentSource;

        BulkIndexRequest(Record record, long requestId, String index, String documentId, String documentSource) {
            this.record = record;
            this.requestId = requestId;
            this.index = index;
            this.documentId = documentId;
            this.documentSource = documentSource;
        }

        public static BulkIndexRequestBuilder builder() {
            return new BulkIndexRequestBuilder();
        }

        public Record getRecord() {
            return this.record;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public String getIndex() {
            return this.index;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public String getDocumentSource() {
            return this.documentSource;
        }

        public static class BulkIndexRequestBuilder {
            private Record record;
            private long requestId;
            private String index;
            private String documentId;
            private String documentSource;

            BulkIndexRequestBuilder() {
            }

            public BulkIndexRequestBuilder record(Record record) {
                this.record = record;
                return this;
            }

            public BulkIndexRequestBuilder requestId(long requestId) {
                this.requestId = requestId;
                return this;
            }

            public BulkIndexRequestBuilder index(String index) {
                this.index = index;
                return this;
            }

            public BulkIndexRequestBuilder documentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            public BulkIndexRequestBuilder documentSource(String documentSource) {
                this.documentSource = documentSource;
                return this;
            }

            public BulkIndexRequest build() {
                return new BulkIndexRequest(this.record, this.requestId, this.index, this.documentId, this.documentSource);
            }

            public String toString() {
                return "BulkProcessor.BulkIndexRequest.BulkIndexRequestBuilder(record=" + String.valueOf(this.record) + ", requestId=" + this.requestId + ", index=" + this.index + ", documentId=" + this.documentId + ", documentSource=" + this.documentSource + ")";
            }
        }
    }

    public static interface Listener {
        public void afterBulk(long var1, List<BulkOperationRequest> var3, List<BulkOperationResult> var4);

        public void afterBulk(long var1, List<BulkOperationRequest> var3, Throwable var4);
    }

    public static class BulkOperationResult {
        private String error;
        private String index;
        private String documentId;

        public boolean isError() {
            return this.error != null;
        }

        BulkOperationResult(String error, String index, String documentId) {
            this.error = error;
            this.index = index;
            this.documentId = documentId;
        }

        public static BulkOperationResultBuilder builder() {
            return new BulkOperationResultBuilder();
        }

        public String getError() {
            return this.error;
        }

        public String getIndex() {
            return this.index;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public static class BulkOperationResultBuilder {
            private String error;
            private String index;
            private String documentId;

            BulkOperationResultBuilder() {
            }

            public BulkOperationResultBuilder error(String error) {
                this.error = error;
                return this;
            }

            public BulkOperationResultBuilder index(String index) {
                this.index = index;
                return this;
            }

            public BulkOperationResultBuilder documentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            public BulkOperationResult build() {
                return new BulkOperationResult(this.error, this.index, this.documentId);
            }

            public String toString() {
                return "BulkProcessor.BulkOperationResult.BulkOperationResultBuilder(error=" + this.error + ", index=" + this.index + ", documentId=" + this.documentId + ")";
            }
        }
    }

    public static class BulkOperationRequest {
        private Record pulsarRecord;

        BulkOperationRequest(Record pulsarRecord) {
            this.pulsarRecord = pulsarRecord;
        }

        public static BulkOperationRequestBuilder builder() {
            return new BulkOperationRequestBuilder();
        }

        public Record getPulsarRecord() {
            return this.pulsarRecord;
        }

        public static class BulkOperationRequestBuilder {
            private Record pulsarRecord;

            BulkOperationRequestBuilder() {
            }

            public BulkOperationRequestBuilder pulsarRecord(Record pulsarRecord) {
                this.pulsarRecord = pulsarRecord;
                return this;
            }

            public BulkOperationRequest build() {
                return new BulkOperationRequest(this.pulsarRecord);
            }

            public String toString() {
                return "BulkProcessor.BulkOperationRequest.BulkOperationRequestBuilder(pulsarRecord=" + String.valueOf(this.pulsarRecord) + ")";
            }
        }
    }
}

