/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngine;
import org.apache.qpid.proton.engine.impl.ssl.SslTransportWrapper;

public class SimpleSslTransportWrapper
implements SslTransportWrapper {
    private static final Logger _logger = Logger.getLogger(SimpleSslTransportWrapper.class.getName());
    private final ProtonSslEngine _sslEngine;
    private final TransportInput _underlyingInput;
    private final TransportOutput _underlyingOutput;
    private boolean _tail_closed = false;
    private ByteBuffer _inputBuffer;
    private boolean _head_closed = false;
    private ByteBuffer _outputBuffer;
    private ByteBuffer _head;
    private ByteBuffer _decodedInputBuffer;
    private String _cipherName;
    private String _protocolName;

    SimpleSslTransportWrapper(ProtonSslEngine sslEngine, TransportInput underlyingInput, TransportOutput underlyingOutput) {
        this._underlyingInput = underlyingInput;
        this._underlyingOutput = underlyingOutput;
        this._sslEngine = sslEngine;
        int effectiveAppBufferMax = this._sslEngine.getEffectiveApplicationBufferSize();
        int packetSize = this._sslEngine.getPacketBufferSize();
        this._inputBuffer = ByteBufferUtils.newWriteableBuffer(packetSize);
        this._outputBuffer = ByteBufferUtils.newWriteableBuffer(packetSize);
        this._head = this._outputBuffer.asReadOnlyBuffer();
        this._head.limit(0);
        this._decodedInputBuffer = ByteBufferUtils.newWriteableBuffer(effectiveAppBufferMax);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Constructed " + this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void unwrapInput() throws SSLException {
        block11: while (true) {
            result = this._sslEngine.unwrap(this._inputBuffer, this._decodedInputBuffer);
            this.logEngineClientModeAndResult(result, "input");
            read = result.bytesProduced();
            status = result.getStatus();
            hstatus = result.getHandshakeStatus();
            capacity = this._underlyingInput.capacity();
            if (capacity == -1 || capacity <= 0) {
                this._tail_closed = true;
                if (this._decodedInputBuffer.position() > 0) {
                    throw new TransportException("bytes left unconsumed");
                }
            } else {
                this._decodedInputBuffer.flip();
                while (this._decodedInputBuffer.hasRemaining() && capacity > 0) {
                    tail = this._underlyingInput.tail();
                    limit = this._decodedInputBuffer.limit();
                    overflow = this._decodedInputBuffer.remaining() - capacity;
                    if (overflow > 0) {
                        this._decodedInputBuffer.limit(limit - overflow);
                    }
                    tail.put(this._decodedInputBuffer);
                    this._decodedInputBuffer.limit(limit);
                    this._underlyingInput.process();
                    capacity = this._underlyingInput.capacity();
                }
                if (capacity == -1 || capacity <= 0) {
                    this._tail_closed = true;
                    if (this._decodedInputBuffer.hasRemaining()) {
                        throw new TransportException("bytes left unconsumed");
                    }
                }
                this._decodedInputBuffer.compact();
            }
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[status.ordinal()]) {
                case 1: {
                    this._tail_closed = true;
                    break;
                }
                case 2: {
                    old = this._decodedInputBuffer;
                    this._decodedInputBuffer = ByteBufferUtils.newWriteableBuffer(old.capacity() * 2);
                    old.flip();
                    this._decodedInputBuffer.put(old);
                    continue block11;
                }
                case 3: {
                    if (!this._tail_closed) break;
                    this._head_closed = true;
                    break;
                }
            }
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[hstatus.ordinal()]) {
                case 1: {
                    break block11;
                }
                case 2: {
                    this.runDelegatedTasks(result);
                    continue block11;
                }
                case 3: {
                    this.updateCipherAndProtocolName(result);
                }
                case 4: 
                case 5: {
                    if (this._inputBuffer.position() <= 0 || status != SSLEngineResult.Status.OK) ** break;
                    continue block11;
                    if (this._inputBuffer.position() != 0 || hstatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !this._tail_closed) break block11;
                    this._head_closed = true;
                }
            }
            break;
        }
    }

    private void wrapOutput() throws SSLException {
        block13: while (true) {
            int pending;
            if ((pending = this._underlyingOutput.pending()) < 0) {
                this._head_closed = true;
            }
            ByteBuffer clearOutputBuffer = this._underlyingOutput.head();
            SSLEngineResult result = this._sslEngine.wrap(clearOutputBuffer, this._outputBuffer);
            this.logEngineClientModeAndResult(result, "output");
            int written = result.bytesConsumed();
            this._underlyingOutput.pop(written);
            pending = this._underlyingOutput.pending();
            SSLEngineResult.Status status = result.getStatus();
            switch (status) {
                case CLOSED: {
                    this._head_closed = true;
                    break;
                }
                case OK: {
                    break;
                }
                case BUFFER_OVERFLOW: {
                    ByteBuffer old = this._outputBuffer;
                    this._outputBuffer = ByteBufferUtils.newWriteableBuffer(this._outputBuffer.capacity() * 2);
                    this._head = this._outputBuffer.asReadOnlyBuffer();
                    old.flip();
                    this._outputBuffer.put(old);
                    continue block13;
                }
                case BUFFER_UNDERFLOW: {
                    throw new IllegalStateException("app buffer underflow");
                }
            }
            SSLEngineResult.HandshakeStatus hstatus = result.getHandshakeStatus();
            switch (hstatus) {
                case NEED_UNWRAP: {
                    if (this._inputBuffer.position() != 0 || !this._tail_closed) break block13;
                    this._head_closed = true;
                    break block13;
                }
                case NEED_WRAP: {
                    continue block13;
                }
                case NEED_TASK: {
                    this.runDelegatedTasks(result);
                    continue block13;
                }
                case FINISHED: {
                    this.updateCipherAndProtocolName(result);
                }
                case NOT_HANDSHAKING: {
                    if (pending <= 0 || status != SSLEngineResult.Status.OK) break block13;
                    continue block13;
                }
            }
            break;
        }
    }

    private boolean hasSpaceForSslPacket(ByteBuffer byteBuffer) {
        return byteBuffer.remaining() >= this._sslEngine.getPacketBufferSize();
    }

    @Override
    public String getCipherName() {
        return this._cipherName;
    }

    @Override
    public String getProtocolName() {
        return this._protocolName;
    }

    private void updateCipherAndProtocolName(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this._cipherName = this._sslEngine.getCipherSuite();
            this._protocolName = this._sslEngine.getProtocol();
        }
    }

    private void runDelegatedTasks(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this._sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = this._sslEngine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new RuntimeException("handshake shouldn't need additional tasks");
            }
        }
    }

    private void logEngineClientModeAndResult(SSLEngineResult result, String direction) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "useClientMode = " + this._sslEngine.getUseClientMode() + " direction = " + direction + " " + this.resultToString(result));
        }
    }

    private String resultToString(SSLEngineResult result) {
        return "[SSLEngineResult status = " + (Object)((Object)result.getStatus()) + " handshakeStatus = " + (Object)((Object)result.getHandshakeStatus()) + " bytesConsumed = " + result.bytesConsumed() + " bytesProduced = " + result.bytesProduced() + "]";
    }

    @Override
    public int capacity() {
        if (this._tail_closed) {
            return -1;
        }
        return this._inputBuffer.remaining();
    }

    @Override
    public int position() {
        if (this._tail_closed) {
            return -1;
        }
        return this._inputBuffer.position();
    }

    @Override
    public ByteBuffer tail() {
        if (this._tail_closed) {
            throw new TransportException("tail closed");
        }
        return this._inputBuffer;
    }

    @Override
    public void process() throws TransportException {
        if (this._tail_closed) {
            throw new TransportException("tail closed");
        }
        this._inputBuffer.flip();
        try {
            this.unwrapInput();
        }
        catch (SSLException e) {
            _logger.log(Level.WARNING, e.getMessage());
            this._inputBuffer.position(this._inputBuffer.limit());
            this._tail_closed = true;
        }
        finally {
            this._inputBuffer.compact();
        }
    }

    @Override
    public void close_tail() {
        try {
            this._underlyingInput.close_tail();
        }
        finally {
            this._tail_closed = true;
        }
    }

    @Override
    public int pending() {
        try {
            this.wrapOutput();
        }
        catch (SSLException e) {
            _logger.log(Level.WARNING, e.getMessage());
            this._head_closed = true;
        }
        this._head.limit(this._outputBuffer.position());
        if (this._head_closed && this._outputBuffer.position() == 0) {
            return -1;
        }
        return this._outputBuffer.position();
    }

    @Override
    public ByteBuffer head() {
        this.pending();
        return this._head;
    }

    @Override
    public void pop(int bytes) {
        this._outputBuffer.flip();
        this._outputBuffer.position(bytes);
        this._outputBuffer.compact();
        this._head.position(0);
        this._head.limit(this._outputBuffer.position());
    }

    @Override
    public void close_head() {
        this._underlyingOutput.close_head();
        int p = this.pending();
        if (p > 0) {
            this.pop(p);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleSslTransportWrapper [sslEngine=").append(this._sslEngine).append(", inputBuffer=").append(this._inputBuffer).append(", outputBuffer=").append(this._outputBuffer).append(", decodedInputBuffer=").append(this._decodedInputBuffer).append(", cipherName=").append(this._cipherName).append(", protocolName=").append(this._protocolName).append("]");
        return builder.toString();
    }
}

