/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.Xid;

public final class DtxCommit
extends Method {
    public static final int TYPE = 1540;
    private short packing_flags = 0;
    private Xid xid;

    @Override
    public final int getStructType() {
        return 1540;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public DtxCommit() {
    }

    public DtxCommit(Xid xid, Option ... _options) {
        if (xid != null) {
            this.setXid(xid);
        }
        block7: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case ONE_PHASE: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block7;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block7;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block7;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block7;
                }
                case NONE: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + _options[i]);
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.dtxCommit(context, this);
    }

    public final boolean hasXid() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final DtxCommit clearXid() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.xid = null;
        this.setDirty(true);
        return this;
    }

    public final Xid getXid() {
        return this.xid;
    }

    public final DtxCommit setXid(Xid value) {
        this.xid = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final DtxCommit xid(Xid value) {
        return this.setXid(value);
    }

    public final boolean hasOnePhase() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final DtxCommit clearOnePhase() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getOnePhase() {
        return this.hasOnePhase();
    }

    public final DtxCommit setOnePhase(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final DtxCommit onePhase(boolean value) {
        return this.setOnePhase(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStruct(1540, this.xid);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.xid = (Xid)dec.readStruct(1540);
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("xid", this.getXid());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("onePhase", this.getOnePhase());
        }
        return result;
    }
}

