/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.store.jdbc;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import org.apache.qpid.server.model.ModelVersion;
import org.apache.qpid.server.protocol.v1_0.LinkDefinition;
import org.apache.qpid.server.protocol.v1_0.LinkDefinitionImpl;
import org.apache.qpid.server.protocol.v1_0.LinkKey;
import org.apache.qpid.server.protocol.v1_0.store.AbstractLinkStore;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreUpdater;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreUtils;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.JDBCContainer;
import org.apache.qpid.server.store.jdbc.JDBCDetails;
import org.apache.qpid.server.store.jdbc.JdbcUtils;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCLinkStore
extends AbstractLinkStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCLinkStore.class);
    private static final String LINKS_TABLE_NAME_SUFFIX = "AMQP_1_0_LINKS";
    private static final String VERSION_TABLE_NAME_SUFFIX = "AMQP_1_0_LINKS_VERSION";
    private final JDBCContainer _jdbcContainer;
    private final String _tableNamePrefix;
    private final String _sqlBlobType;
    private final String _sqlTimestampType;
    private final boolean _isUseBytesMethodsForBlob;
    private final Action<Connection> _cleanUpAction;

    JDBCLinkStore(JDBCContainer jdbcContainer) {
        this._jdbcContainer = jdbcContainer;
        this._tableNamePrefix = jdbcContainer.getTableNamePrefix();
        JDBCDetails jdbcDetails = jdbcContainer.getJDBCDetails();
        this._sqlBlobType = jdbcDetails.getBlobType();
        this._sqlTimestampType = jdbcDetails.getTimestampType();
        this._isUseBytesMethodsForBlob = jdbcDetails.isUseBytesMethodsForBlob();
        this._cleanUpAction = this::cleanUp;
        jdbcContainer.addDeleteAction(this._cleanUpAction);
    }

    protected Collection<LinkDefinition<Source, Target>> doOpenAndLoad(LinkStoreUpdater updater) throws StoreException {
        Collection<LinkDefinition<Source, Target>> linkDefinitions;
        try {
            this.checkTransactionIsolationLevel();
            this.createOrOpenStoreDatabase();
            linkDefinitions = this.getLinks();
            ModelVersion storedVersion = this.getStoredVersion();
            ModelVersion currentVersion = new ModelVersion(8, 0);
            if (storedVersion.lessThan(currentVersion)) {
                linkDefinitions = this.performUpdate(updater, linkDefinitions, storedVersion, currentVersion);
            } else if (currentVersion.lessThan(storedVersion)) {
                throw new StoreException(String.format("Cannot downgrade the store from %s to %s", storedVersion, currentVersion));
            }
        }
        catch (SQLException e) {
            throw new StoreException("Cannot open link store", (Throwable)e);
        }
        return linkDefinitions;
    }

    protected void doClose() throws StoreException {
    }

    protected void doSaveLink(LinkDefinition<Source, Target> link) throws StoreException {
        String linkKey = this.generateLinkKey(link);
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(8);
            try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("SELECT remote_container_id, link_name, link_role, source, target FROM %s WHERE link_key = ?", this.getLinksTableName()));){
                preparedStatement.setString(1, linkKey);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        this.update(connection, linkKey, link);
                    } else {
                        this.insert(connection, linkKey, link);
                    }
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException re) {
                LOGGER.debug("Rollback failed on rolling back saving link transaction", (Throwable)re);
            }
            throw new StoreException(String.format("Cannot save link %s", new LinkKey(link)), (Throwable)e);
        }
        finally {
            JdbcUtils.closeConnection((Connection)connection, (Logger)LOGGER);
        }
    }

    protected void doDeleteLink(LinkDefinition<Source, Target> link) throws StoreException {
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(String.format("DELETE FROM %s WHERE link_key = ?", this.getLinksTableName()));){
            preparedStatement.setString(1, this.generateLinkKey(link));
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new StoreException(String.format("Cannot delete link %s", new LinkKey(link)), (Throwable)e);
        }
    }

    protected void doDelete() {
        this._jdbcContainer.removeDeleteAction(this._cleanUpAction);
        try (Connection connection = this.getConnection();){
            this.cleanUp(connection);
        }
        catch (IllegalStateException e) {
            LOGGER.warn("Could not delete Link store: {}", (Object)e.getMessage());
        }
        catch (SQLException e) {
            throw new StoreException("Error deleting Link store", (Throwable)e);
        }
    }

    private void cleanUp(Connection connection) {
        JdbcUtils.dropTables((Connection)connection, (Logger)LOGGER, Arrays.asList(this.getLinksTableName(), this.getVersionTableName()));
    }

    public TerminusDurability getHighestSupportedTerminusDurability() {
        return TerminusDurability.CONFIGURATION;
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            if (!metaData.supportsTransactionIsolationLevel(8)) {
                throw new StoreException(String.format("The RDBMS '%s' does not support required transaction isolation level 'serializable'", metaData.getDatabaseProductName()));
            }
        }
    }

    private Connection getConnection() {
        return this._jdbcContainer.getConnection();
    }

    private void createOrOpenStoreDatabase() throws SQLException {
        try (Connection conn = this.getConnection();){
            conn.setAutoCommit(true);
            this.createLinksTable(conn);
            this.createVersionTable(conn);
        }
    }

    private void createVersionTable(Connection conn) throws SQLException {
        String versionTableName = this.getVersionTableName();
        if (!JdbcUtils.tableExists((String)versionTableName, (Connection)conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(String.format("CREATE TABLE %s (version varchar(10) PRIMARY KEY , version_time %s)", versionTableName, this._sqlTimestampType));
            }
            this.updateVersion(conn, ModelVersion.fromString((String)"8.0"));
        }
    }

    private void createLinksTable(Connection conn) throws SQLException {
        if (!JdbcUtils.tableExists((String)this.getLinksTableName(), (Connection)conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(String.format("CREATE TABLE %1$s ( link_key varchar(44) PRIMARY KEY , remote_container_id %2$s,  link_name %2$s, link_role INTEGER, source %2$s, target %2$s )", this.getLinksTableName(), this._sqlBlobType));
            }
        }
    }

    private String getLinksTableName() {
        return this._tableNamePrefix + LINKS_TABLE_NAME_SUFFIX;
    }

    private String getVersionTableName() {
        return this._tableNamePrefix + VERSION_TABLE_NAME_SUFFIX;
    }

    private Collection<LinkDefinition<Source, Target>> performUpdate(LinkStoreUpdater updater, Collection<LinkDefinition<Source, Target>> linkDefinitions, ModelVersion storedVersion, ModelVersion currentVersion) throws SQLException {
        linkDefinitions = updater.update(storedVersion.toString(), linkDefinitions);
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            try (Statement statement = connection.createStatement();){
                statement.execute("DELETE FROM " + this.getLinksTableName());
            }
            for (LinkDefinition linkDefinition : linkDefinitions) {
                this.insert(connection, this.generateLinkKey(linkDefinition), (LinkDefinition<? extends BaseSource, ? extends BaseTarget>)linkDefinition);
            }
            this.updateVersion(connection, currentVersion);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException re) {
                LOGGER.debug("Cannot rollback transaction", (Throwable)re);
            }
            throw e;
        }
        finally {
            JdbcUtils.closeConnection((Connection)connection, (Logger)LOGGER);
        }
        return linkDefinitions;
    }

    private Collection<LinkDefinition<Source, Target>> getLinks() throws SQLException {
        ArrayList<LinkDefinition<Source, Target>> links = new ArrayList<LinkDefinition<Source, Target>>();
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SELECT remote_container_id, link_name, link_role, source, target FROM %s", this.getLinksTableName()));){
            while (resultSet.next()) {
                String remoteContainerId = this.getBlobValueAsString(resultSet, 1);
                String linkName = this.getBlobValueAsString(resultSet, 2);
                Role role = Role.valueOf((Object)resultSet.getBoolean(3));
                Source source = (Source)this.getBlobAsAmqpObject(resultSet, 4);
                Target target = (Target)this.getBlobAsAmqpObject(resultSet, 5);
                links.add((LinkDefinition<Source, Target>)new LinkDefinitionImpl(remoteContainerId, linkName, role, (BaseSource)source, (BaseTarget)target));
            }
        }
        catch (IllegalArgumentException e) {
            throw new StoreException("Cannot load links from store", (Throwable)e);
        }
        return links;
    }

    private Object getBlobAsAmqpObject(ResultSet resultSet, int index) throws SQLException {
        byte[] sourceBytes;
        if (this._isUseBytesMethodsForBlob) {
            sourceBytes = resultSet.getBytes(index);
        } else {
            Blob blob = resultSet.getBlob(index);
            try (InputStream is = blob.getBinaryStream();){
                sourceBytes = ByteStreams.toByteArray((InputStream)is);
            }
            catch (IOException e) {
                throw new StoreException("Cannot convert blob to string", (Throwable)e);
            }
            finally {
                blob.free();
            }
        }
        return LinkStoreUtils.amqpBytesToObject((byte[])sourceBytes);
    }

    /*
     * Exception decompiling
     */
    private String getBlobValueAsString(ResultSet resultSet, int index) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ModelVersion getStoredVersion() throws SQLException {
        ModelVersion version = null;
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SELECT version FROM %s", this.getVersionTableName()));){
            while (resultSet.next()) {
                ModelVersion storedVersion = ModelVersion.fromString((String)resultSet.getString(1));
                if (version != null && !version.lessThan(storedVersion)) continue;
                version = storedVersion;
            }
        }
        if (version == null) {
            throw new StoreException("Version of links is not found");
        }
        return version;
    }

    private void updateVersion(Connection connection, ModelVersion currentVersion) throws SQLException {
        String version = currentVersion.toString();
        try (PreparedStatement statement = connection.prepareStatement(String.format("INSERT INTO %s (version, version_time) VALUES (?,?)", this.getVersionTableName()));){
            statement.setString(1, version);
            statement.setDate(2, new Date(System.currentTimeMillis()));
            if (statement.executeUpdate() != 1) {
                throw new StoreException(String.format("Cannot insert version '%s' into version table", version));
            }
        }
    }

    private void insert(Connection connection, String linkKey, LinkDefinition<? extends BaseSource, ? extends BaseTarget> linkDefinition) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(String.format("INSERT INTO %s (link_key, remote_container_id, link_name, link_role, source, target) VALUES (?,?,?,?,?,?)", this.getLinksTableName()));){
            statement.setString(1, linkKey);
            this.saveStringAsBlob(statement, 2, linkDefinition.getRemoteContainerId());
            this.saveStringAsBlob(statement, 3, linkDefinition.getName());
            statement.setInt(4, linkDefinition.getRole().getValue() != false ? 1 : 0);
            this.saveObjectAsBlob(statement, 5, linkDefinition.getSource());
            this.saveObjectAsBlob(statement, 6, linkDefinition.getTarget());
            if (statement.executeUpdate() != 1) {
                throw new StoreException(String.format("Cannot save link %s", new LinkKey(linkDefinition)));
            }
        }
    }

    private void update(Connection connection, String linkKey, LinkDefinition<? extends BaseSource, ? extends BaseTarget> linkDefinition) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(String.format("UPDATE %s SET source = ?, target = ? WHERE link_key = ?", this.getLinksTableName()));){
            this.saveObjectAsBlob(statement, 1, linkDefinition.getSource());
            this.saveObjectAsBlob(statement, 2, linkDefinition.getTarget());
            statement.setString(3, linkKey);
            if (statement.executeUpdate() != 1) {
                throw new StoreException(String.format("Cannot save link %s", new LinkKey(linkDefinition)));
            }
        }
    }

    private void saveObjectAsBlob(PreparedStatement statement, int index, Object object) throws SQLException {
        this.saveBytesAsBlob(statement, index, LinkStoreUtils.objectToAmqpBytes((Object)object));
    }

    private void saveBytesAsBlob(PreparedStatement statement, int index, byte[] bytes) throws SQLException {
        if (this._isUseBytesMethodsForBlob) {
            statement.setBytes(index, bytes);
        } else {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                statement.setBlob(index, inputStream);
            }
            catch (IOException e) {
                throw new StoreException("Cannot save link", (Throwable)e);
            }
        }
    }

    private void saveStringAsBlob(PreparedStatement statement, int index, String value) throws SQLException {
        this.saveBytesAsBlob(statement, index, value.getBytes(StandardCharsets.UTF_8));
    }

    private String generateLinkKey(LinkDefinition<?, ?> linkDefinition) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new StoreException("Cannot generate SHA-256 checksum", (Throwable)e);
        }
        md.update(linkDefinition.getRemoteContainerId().getBytes(StandardCharsets.UTF_8));
        md.update(linkDefinition.getName().getBytes(StandardCharsets.UTF_8));
        md.update(linkDefinition.getRole().getValue() != false ? (byte)1 : 0);
        return Base64.getEncoder().encodeToString(md.digest());
    }
}

