/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Arrays;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.protocol.v1_0.NodeReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Rejected;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.txn.ServerTransaction;

public class AnonymousRelayDestination
implements ReceivingDestination {
    private final Target _target;
    private final NamedAddressSpace _addressSpace;
    private final EventLogger _eventLogger;
    private final boolean _discardUnroutable;

    AnonymousRelayDestination(NamedAddressSpace addressSpace, Target target, EventLogger eventLogger) {
        this._addressSpace = addressSpace;
        this._target = target;
        this._eventLogger = eventLogger;
        this._discardUnroutable = target.getCapabilities() != null && Arrays.asList(target.getCapabilities()).contains(DISCARD_UNROUTABLE);
    }

    @Override
    public Symbol[] getCapabilities() {
        return new Symbol[]{Session_1_0.DELAYED_DELIVERY};
    }

    @Override
    public Outcome[] getOutcomes() {
        return new Outcome[0];
    }

    @Override
    public Outcome send(ServerMessage<?> message, ServerTransaction txn, SecurityToken securityToken) {
        Outcome outcome;
        String routingAddress = message.getTo();
        DestinationAddress destinationAddress = new DestinationAddress(this._addressSpace, routingAddress);
        MessageDestination messageDestination = destinationAddress.getMessageDestination();
        ReceivingDestination destination = messageDestination != null ? new NodeReceivingDestination(destinationAddress, this._target.getDurable(), this._target.getExpiryPolicy(), this._target.getCapabilities(), this._eventLogger) : null;
        if (destination == null) {
            if (this._discardUnroutable) {
                this._eventLogger.message(ExchangeMessages.DISCARDMSG((String)"", (String)routingAddress));
                outcome = new Accepted();
            } else {
                outcome = this.createdRejectedOutcome(AmqpError.NOT_FOUND, "Unknown destination '" + routingAddress + "'");
            }
        } else {
            outcome = destination.send(message, txn, securityToken);
        }
        return outcome;
    }

    @Override
    public int getCredit() {
        return 20000;
    }

    @Override
    public String getAddress() {
        return "";
    }

    @Override
    public MessageDestination getMessageDestination() {
        return null;
    }

    private Outcome createdRejectedOutcome(AmqpError errorCode, String errorMessage) {
        Rejected rejected = new Rejected();
        Error notFoundError = new Error(errorCode, errorMessage);
        rejected.setError(notFoundError);
        return rejected;
    }
}

