/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Arrays;
import java.util.Collections;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.RejectType;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Rejected;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.txn.ServerTransaction;

public class NodeReceivingDestination
implements ReceivingDestination {
    private static final Accepted ACCEPTED = new Accepted();
    public static final Rejected REJECTED = new Rejected();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED, REJECTED};
    private final boolean _discardUnroutable;
    private final EventLogger _eventLogger;
    private final MessageDestination _destination;
    private final TerminusDurability _durability;
    private final TerminusExpiryPolicy _expiryPolicy;
    private final String _address;
    private final String _routingAddress;

    public NodeReceivingDestination(DestinationAddress destinationAddress, TerminusDurability durable, TerminusExpiryPolicy expiryPolicy, Symbol[] capabilities, EventLogger eventLogger) {
        this._destination = destinationAddress.getMessageDestination();
        this._durability = durable;
        this._expiryPolicy = expiryPolicy;
        this._eventLogger = eventLogger;
        if (this._destination instanceof Exchange) {
            this._discardUnroutable = capabilities != null && Arrays.asList(capabilities).contains(DISCARD_UNROUTABLE) || ((Exchange)this._destination).getUnroutableMessageBehaviour() == Exchange.UnroutableMessageBehaviour.DISCARD;
            this._routingAddress = destinationAddress.getRoutingKey();
            this._address = this._destination.getName();
        } else {
            this._discardUnroutable = false;
            this._routingAddress = "";
            this._address = destinationAddress.getRoutingAddress();
        }
    }

    @Override
    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    @Override
    public Outcome send(final ServerMessage<?> message, ServerTransaction txn, SecurityToken securityToken) {
        String routingAddress = "".equals(this._routingAddress) ? this.getRoutingAddress(message) : this._routingAddress;
        this._destination.authorisePublish(securityToken, Collections.singletonMap("routingKey", routingAddress));
        InstanceProperties instanceProperties = new InstanceProperties(){

            public Object getProperty(InstanceProperties.Property prop) {
                switch (prop) {
                    case MANDATORY: {
                        return false;
                    }
                    case REDELIVERED: {
                        return false;
                    }
                    case PERSISTENT: {
                        return message.isPersistent();
                    }
                    case IMMEDIATE: {
                        return false;
                    }
                    case EXPIRATION: {
                        return message.getExpiration();
                    }
                }
                return null;
            }
        };
        RoutingResult result = this._destination.route(message, routingAddress, instanceProperties);
        int enqueues = result.send(txn, null);
        if (enqueues == 0) {
            if (!this._discardUnroutable) {
                if (result.isRejected()) {
                    AmqpError error = result.containsReject(new RejectType[]{RejectType.LIMIT_EXCEEDED}) ? AmqpError.RESOURCE_LIMIT_EXCEEDED : (result.containsReject(new RejectType[]{RejectType.PRECONDITION_FAILED}) ? AmqpError.PRECONDITION_FAILED : AmqpError.ILLEGAL_STATE);
                    return this.createdRejectedOutcome(error, result.getRejectReason());
                }
                return this.createdRejectedOutcome(AmqpError.NOT_FOUND, String.format("Unknown destination '%s'", routingAddress));
            }
            this._eventLogger.message(ExchangeMessages.DISCARDMSG((String)this._destination.getName(), (String)routingAddress));
        }
        return ACCEPTED;
    }

    private String getRoutingAddress(ServerMessage<?> message) {
        String initialRoutingAddress = message.getInitialRoutingAddress();
        if (initialRoutingAddress == null || "".equals(initialRoutingAddress)) {
            String string = initialRoutingAddress = message.getTo() == null ? "" : message.getTo();
        }
        if (this._address != null && initialRoutingAddress.startsWith(this._address + "/")) {
            initialRoutingAddress = initialRoutingAddress.substring(this._address.length() + 1);
        }
        return initialRoutingAddress;
    }

    private Outcome createdRejectedOutcome(AmqpError errorCode, String errorMessage) {
        Rejected rejected = new Rejected();
        Error notFoundError = new Error(errorCode, errorMessage);
        rejected.setError(notFoundError);
        return rejected;
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public MessageDestination getMessageDestination() {
        return this._destination;
    }

    TerminusDurability getDurability() {
        return this._durability;
    }

    TerminusExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    @Override
    public int getCredit() {
        return 20000;
    }

    public MessageDestination getDestination() {
        return this._destination;
    }

    @Override
    public Symbol[] getCapabilities() {
        Symbol[] capabilities = new Symbol[]{this._discardUnroutable ? DISCARD_UNROUTABLE : REJECT_UNROUTABLE, Session_1_0.DELAYED_DELIVERY};
        return capabilities;
    }
}

