/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.protocol.MessageFormatRegistry;
import org.apache.qpid.server.protocol.v1_0.AbstractReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Delivery;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.SequenceNumber;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.UnknownTransactionException;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorRuntimeException;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Rejected;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Coordinator;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionError;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionalState;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardReceivingLinkEndpoint
extends AbstractReceivingLinkEndpoint<Target> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardReceivingLinkEndpoint.class);
    private static final String LINK = "link";
    private ReceivingDestination _receivingDestination;
    private final PublishingLink _publishingLink = new PublishingLink(){

        public String getName() {
            return StandardReceivingLinkEndpoint.this.getLinkName();
        }

        public String getType() {
            return StandardReceivingLinkEndpoint.LINK;
        }

        public String getDestination() {
            ReceivingDestination receivingDestination = StandardReceivingLinkEndpoint.this._receivingDestination;
            return receivingDestination == null ? "" : StandardReceivingLinkEndpoint.this._receivingDestination.getAddress();
        }
    };
    private final MessageSender _messageSender = new MessageSender(){

        public void destinationRemoved(MessageDestination destination) {
        }

        public Collection<? extends PublishingLink> getPublishingLinks(MessageDestination destination) {
            ReceivingDestination receivingDestination = StandardReceivingLinkEndpoint.this._receivingDestination;
            MessageDestination actualDestination = receivingDestination == null ? null : receivingDestination.getMessageDestination();
            return actualDestination != null && actualDestination.equals(destination) ? Collections.singleton(StandardReceivingLinkEndpoint.this._publishingLink) : Collections.emptyList();
        }
    };

    public StandardReceivingLinkEndpoint(Session_1_0 session, Link_1_0<Source, Target> link) {
        super(session, link);
    }

    @Override
    public void start() {
        this.setLinkCredit(UnsignedInteger.valueOf(this.getReceivingDestination().getCredit()));
        this.setCreditWindow();
    }

    private TerminusDurability getDurability() {
        return ((Target)this.getTarget()).getDurable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Error receiveDelivery(final Delivery delivery) {
        block49: {
            block46: {
                block50: {
                    transferReceiverSettleMode = delivery.getReceiverSettleMode();
                    if (!delivery.getResume()) break block50;
                    deliveryState = (DeliveryState)this._unsettled.get(delivery.getDeliveryTag());
                    if (deliveryState instanceof Outcome) {
                        settled = this.shouldReceiverSettleFirst(transferReceiverSettleMode);
                        this.updateDisposition(delivery.getDeliveryTag(), deliveryState, settled);
                        return null;
                    }
                    break block49;
                }
                messageFormat = delivery.getMessageFormat();
                xfrState = delivery.getState();
                format = MessageFormatRegistry.getFormat((int)messageFormat.intValue());
                if (format != null) {
                    try {
                        payload = delivery.getPayload();
                        var8_12 = null;
                        try {
                            serverMessage = format.createMessage(payload, this.getAddressSpace().getMessageStore(), this.getSession().getConnection().getReference());
                            break block46;
                        }
                        catch (Throwable var9_14) {
                            var8_12 = var9_14;
                            throw var9_14;
                        }
                        finally {
                            if (payload != null) {
                                if (var8_12 != null) {
                                    try {
                                        payload.close();
                                    }
                                    catch (Throwable var9_13) {
                                        var8_12.addSuppressed(var9_13);
                                    }
                                } else {
                                    payload.close();
                                }
                            }
                        }
                    }
                    catch (AmqpErrorRuntimeException e) {
                        return e.getCause().getError();
                    }
                }
                err = new Error();
                err.setCondition(AmqpError.NOT_IMPLEMENTED);
                err.setDescription("Unknown message format: " + messageFormat);
                return err;
            }
            reference = serverMessage.newReference();
            try {
                block48: {
                    block47: {
                        transactionId = null;
                        if (xfrState != null && xfrState instanceof TransactionalState) {
                            transactionId = ((TransactionalState)xfrState).getTxnId();
                        }
                        setRollbackOnly = true;
                        if (transactionId != null) {
                            try {
                                transaction = this.getSession().getTransaction(transactionId);
                            }
                            catch (UnknownTransactionException e) {
                                var12_22 = new Error(TransactionError.UNKNOWN_ID, String.format("transaction-id '%s' is unknown.", new Object[]{transactionId}));
                                reference.release();
                                return var12_22;
                            }
                            if (!(transaction instanceof AutoCommitTransaction)) {
                                transaction.addPostTransactionAction(new ServerTransaction.Action(){

                                    public void postCommit() {
                                        StandardReceivingLinkEndpoint.this.updateDisposition(delivery.getDeliveryTag(), null, true);
                                    }

                                    public void onRollback() {
                                        StandardReceivingLinkEndpoint.this.updateDisposition(delivery.getDeliveryTag(), null, true);
                                    }
                                });
                            }
                        } else {
                            transaction = new AutoCommitTransaction(this.getAddressSpace().getMessageStore());
                        }
                        session = this.getSession();
                        session.getAMQPConnection().checkAuthorizedMessagePrincipal(serverMessage.getMessageHeader().getUserId());
                        source = (Source)this.getSource();
                        if (!serverMessage.isPersistent() || this.getAddressSpace().getMessageStore().isPersistent()) ** GOTO lbl77
                        preconditionFailedError = new Error(AmqpError.PRECONDITION_FAILED, "Non-durable message store cannot accept durable message.");
                        if (source.getOutcomes() != null && Arrays.asList(source.getOutcomes()).contains(Rejected.REJECTED_SYMBOL)) {
                            rejected = new Rejected();
                            rejected.setError(preconditionFailedError);
                            outcome = rejected;
                            break block47;
                        }
                        rejected = preconditionFailedError;
                        if (setRollbackOnly && transaction instanceof LocalTransaction) {
                            ((LocalTransaction)transaction).setRollbackOnly();
                        }
                        return rejected;
                    }
                    try {
                        block51: {
                            break block51;
lbl77:
                            // 1 sources

                            outcome = this.getReceivingDestination().send(serverMessage, transaction, session.getSecurityToken());
                        }
                        sourceSupportedOutcomes = new ArrayList<Symbol>();
                        if (source.getOutcomes() != null) {
                            sourceSupportedOutcomes.addAll(Arrays.asList(source.getOutcomes()));
                        } else if (source.getDefaultOutcome() == null) {
                            sourceSupportedOutcomes.add(Accepted.ACCEPTED_SYMBOL);
                        }
                        v0 = transacted = transactionId != null && transaction instanceof LocalTransaction != false;
                        if (sourceSupportedOutcomes.contains(outcome.getSymbol())) {
                            if (transactionId == null) {
                                resultantState /* !! */  = outcome;
                            } else {
                                transactionalState = new TransactionalState();
                                transactionalState.setOutcome(outcome);
                                transactionalState.setTxnId(transactionId);
                                resultantState /* !! */  = transactionalState;
                            }
                        } else {
                            if (transacted && source.getDefaultOutcome() != null && outcome.getSymbol() != source.getDefaultOutcome().getSymbol()) {
                                ((LocalTransaction)transaction).setRollbackOnly();
                            }
                            resultantState /* !! */  = null;
                        }
                        settled = this.shouldReceiverSettleFirst(transferReceiverSettleMode);
                        this.updateDisposition(delivery.getDeliveryTag(), resultantState /* !! */ , settled);
                        this.getSession().getAMQPConnection().registerMessageReceived(serverMessage.getSize());
                        if (!transacted) break block48;
                        this.getSession().getAMQPConnection().registerTransactedMessageReceived();
                    }
                    catch (AccessControlException e) {
                        try {
                            err = new Error();
                            err.setCondition(AmqpError.NOT_ALLOWED);
                            err.setDescription(e.getMessage());
                            var13_24 = err;
                        }
                        catch (Throwable var18_31) {
                            if (setRollbackOnly && transaction instanceof LocalTransaction) {
                                ((LocalTransaction)transaction).setRollbackOnly();
                            }
                            throw var18_31;
                        }
                        if (setRollbackOnly && transaction instanceof LocalTransaction) {
                            ((LocalTransaction)transaction).setRollbackOnly();
                        }
                        reference.release();
                        return var13_24;
                    }
                }
                if ((setRollbackOnly = false) && transaction instanceof LocalTransaction) {
                    ((LocalTransaction)transaction).setRollbackOnly();
                }
            }
            finally {
                reference.release();
            }
        }
        return null;
    }

    private boolean shouldReceiverSettleFirst(ReceiverSettleMode transferReceiverSettleMode) {
        if (transferReceiverSettleMode == null) {
            transferReceiverSettleMode = this.getReceivingSettlementMode();
        }
        return transferReceiverSettleMode == null || ReceiverSettleMode.FIRST.equals(transferReceiverSettleMode);
    }

    @Override
    protected void remoteDetachedPerformDetach(Detach detach) {
        TerminusExpiryPolicy expiryPolicy = ((Target)this.getTarget()).getExpiryPolicy();
        if (detach != null && Boolean.TRUE.equals(detach.getClosed()) || TerminusExpiryPolicy.LINK_DETACH.equals(expiryPolicy) || (expiryPolicy == null || TerminusExpiryPolicy.SESSION_END.equals(expiryPolicy)) && this.getSession().isClosing() || TerminusExpiryPolicy.CONNECTION_CLOSE.equals(expiryPolicy) && this.getSession().getConnection().isClosing()) {
            this.close();
        } else if (detach == null || detach.getError() != null) {
            this.detach();
            this.destroy();
        } else {
            this.detach();
            this.destroy();
        }
    }

    @Override
    protected Map<Binary, DeliveryState> getLocalUnsettled() {
        return new HashMap<Binary, DeliveryState>(this._unsettled);
    }

    @Override
    public void attachReceived(Attach attach) throws AmqpErrorException {
        super.attachReceived(attach);
        Source source = (Source)attach.getSource();
        Target target = new Target();
        Target attachTarget = (Target)attach.getTarget();
        this.setDeliveryCount(new SequenceNumber(attach.getInitialDeliveryCount().intValue()));
        target.setAddress(attachTarget.getAddress());
        target.setDynamic(attachTarget.getDynamic());
        if (Boolean.TRUE.equals(attachTarget.getDynamic()) && attachTarget.getDynamicNodeProperties() != null) {
            HashMap<Symbol, Object> dynamicNodeProperties = new HashMap<Symbol, Object>();
            if (attachTarget.getDynamicNodeProperties().containsKey(Session_1_0.LIFETIME_POLICY)) {
                dynamicNodeProperties.put(Session_1_0.LIFETIME_POLICY, attachTarget.getDynamicNodeProperties().get(Session_1_0.LIFETIME_POLICY));
            }
            target.setDynamicNodeProperties(dynamicNodeProperties);
        }
        target.setDurable(TerminusDurability.min(attachTarget.getDurable(), this.getLink().getHighestSupportedTerminusDurability()));
        ArrayList<Symbol> targetCapabilities = new ArrayList<Symbol>();
        if (attachTarget.getCapabilities() != null) {
            List<Symbol> desiredCapabilities = Arrays.asList(attachTarget.getCapabilities());
            if (desiredCapabilities.contains(Symbol.valueOf("temporary-topic"))) {
                targetCapabilities.add(Symbol.valueOf("temporary-topic"));
            }
            if (desiredCapabilities.contains(Symbol.valueOf("topic"))) {
                targetCapabilities.add(Symbol.valueOf("topic"));
            }
            target.setCapabilities(targetCapabilities.toArray(new Symbol[targetCapabilities.size()]));
        }
        target.setExpiryPolicy(attachTarget.getExpiryPolicy());
        ReceivingDestination destination = this.getSession().getReceivingDestination(this.getLink(), target);
        targetCapabilities.addAll(Arrays.asList(destination.getCapabilities()));
        target.setCapabilities(targetCapabilities.toArray(new Symbol[targetCapabilities.size()]));
        this.setCapabilities(targetCapabilities);
        this.setDestination(destination);
        if (!Boolean.TRUE.equals(attach.getIncompleteUnsettled())) {
            Map<Binary, DeliveryState> remoteUnsettled = attach.getUnsettled();
            HashMap unsettledCopy = new HashMap(this._unsettled);
            for (Map.Entry entry : unsettledCopy.entrySet()) {
                Binary deliveryTag = (Binary)entry.getKey();
                if (remoteUnsettled != null && remoteUnsettled.containsKey(deliveryTag)) continue;
                this._unsettled.remove(deliveryTag);
            }
        }
        this.getLink().setTermini(source, target);
    }

    public ReceivingDestination getReceivingDestination() {
        return this._receivingDestination;
    }

    public void setDestination(ReceivingDestination receivingDestination) {
        if (this._receivingDestination != receivingDestination) {
            if (this._receivingDestination != null && this._receivingDestination.getMessageDestination() != null) {
                this._receivingDestination.getMessageDestination().linkRemoved(this._messageSender, this._publishingLink);
            }
            this._receivingDestination = receivingDestination;
            if (receivingDestination != null && receivingDestination.getMessageDestination() != null) {
                receivingDestination.getMessageDestination().linkAdded(this._messageSender, this._publishingLink);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this._receivingDestination != null && this._receivingDestination.getMessageDestination() != null) {
            this._receivingDestination.getMessageDestination().linkRemoved(this._messageSender, this._publishingLink);
            this._receivingDestination = null;
        }
    }

    @Override
    protected void recoverLink(Attach attach) throws AmqpErrorException {
        if (this.getTarget() == null) {
            throw new AmqpErrorException(new Error(AmqpError.NOT_FOUND, String.format("Link '%s' not found", this.getLinkName())));
        }
        attach.setTarget((BaseTarget)this.getTarget());
        this.receiveAttach(attach);
    }

    @Override
    protected void reattachLink(Attach attach) throws AmqpErrorException {
        if (attach.getTarget() instanceof Coordinator) {
            throw new AmqpErrorException(new Error(AmqpError.PRECONDITION_FAILED, "Cannot reattach standard receiving Link as a transaction coordinator"));
        }
        this.attachReceived(attach);
    }

    @Override
    protected void resumeLink(Attach attach) throws AmqpErrorException {
        if (this.getTarget() == null) {
            throw new IllegalStateException("Terminus should be set when resuming a Link.");
        }
        if (attach.getTarget() == null) {
            throw new IllegalStateException("Attach.getTarget should not be null when resuming a Link. That would be recovering the Link.");
        }
        if (attach.getTarget() instanceof Coordinator) {
            throw new AmqpErrorException(new Error(AmqpError.PRECONDITION_FAILED, "Cannot resume standard receiving Link as a transaction coordinator"));
        }
        this.attachReceived(attach);
    }

    @Override
    protected void establishLink(Attach attach) throws AmqpErrorException {
        if (this.getSource() != null || this.getTarget() != null) {
            throw new IllegalStateException("Termini should be null when establishing a Link.");
        }
        this.attachReceived(attach);
    }
}

