/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class BinaryTypeConstructor
extends VariableWidthTypeConstructor<Binary> {
    private static final BinaryTypeConstructor INSTANCE_1 = new BinaryTypeConstructor(1);
    private static final BinaryTypeConstructor INSTANCE_4 = new BinaryTypeConstructor(4);

    public static BinaryTypeConstructor getInstance(int i) {
        return i == 1 ? INSTANCE_1 : INSTANCE_4;
    }

    private BinaryTypeConstructor(int size) {
        super(size);
    }

    @Override
    public Binary construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (!in.hasRemaining(this.getSize())) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct binary: insufficient input data", new Object[0]);
        }
        int size = this.getSize() == 1 ? in.getUnsignedByte() : in.getInt();
        if (!in.hasRemaining(size)) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct binary: insufficient input data", new Object[0]);
        }
        byte[] data = new byte[size];
        in.get(data);
        return new Binary(data);
    }
}

