/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.protocol.v1_0.codec.FixedEightWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public class LongWriter {
    private static final byte EIGHT_BYTE_FORMAT_CODE = -127;
    private static final byte ONE_BYTE_FORMAT_CODE = 85;
    private static final ValueWriter.Factory<Long> FACTORY = new ValueWriter.Factory<Long>(){

        @Override
        public ValueWriter<Long> newInstance(ValueWriter.Registry registry, Long l) {
            if (l >= -128L && l <= 127L) {
                return new LongFixedOneWriter(l);
            }
            return new LongFixedEightWriter(l);
        }
    };

    public static void register(ValueWriter.Registry registry) {
        registry.register(Long.class, FACTORY);
    }

    private static class LongFixedOneWriter
    extends FixedOneWriter<Long> {
        public LongFixedOneWriter(Long value) {
            super(value.byteValue());
        }

        @Override
        protected byte getFormatCode() {
            return 85;
        }
    }

    private static class LongFixedEightWriter
    extends FixedEightWriter<Long> {
        public LongFixedEightWriter(Long object) {
            super(object);
        }

        @Override
        byte getFormatCode() {
            return -127;
        }
    }
}

