/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class MapConstructor
extends VariableWidthTypeConstructor<Map<Object, Object>> {
    private MapConstructor(int size) {
        super(size);
    }

    @Override
    public Map<Object, Object> construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        return this.construct(in, handler, Object.class, Object.class);
    }

    public <T, S> Map<T, S> construct(QpidByteBuffer in, ValueHandler handler, Class<T> keyType, Class<S> valueType) throws AmqpErrorException {
        int count;
        int size;
        long remaining = in.remaining();
        if (remaining < (long)(this.getSize() * 2)) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Not sufficient data for deserialization of 'map'. Expected at least %d bytes. Got %d bytes.", this.getSize(), remaining), new Object[0]);
        }
        if (this.getSize() == 1) {
            size = in.getUnsignedByte();
            count = in.getUnsignedByte();
        } else {
            size = in.getInt();
            count = in.getInt();
        }
        if ((remaining -= (long)this.getSize()) < (long)size) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Not sufficient data for deserialization of 'map'. Expected at least %d bytes. Got %d bytes.", size, remaining), new Object[0]);
        }
        return this.construct(in, handler, size, count, keyType, valueType);
    }

    private <T, S> Map<T, S> construct(QpidByteBuffer in, ValueHandler handler, int size, int count, Class<T> keyType, Class<S> valueType) throws AmqpErrorException {
        if ((count & 1) == 1) {
            String message = String.format("Map cannot have odd number of elements: %d", count);
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, message, new Object[0]);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(count);
        int mapSize = count / 2;
        for (int i = 0; i < mapSize; ++i) {
            Object key = handler.parse(in);
            if (key != null && !keyType.isAssignableFrom(key.getClass())) {
                String message = String.format("Expected key type is '%s' but got '%s'", keyType.getSimpleName(), key.getClass().getSimpleName());
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, message, new Object[0]);
            }
            Object value = handler.parse(in);
            if (value != null && !valueType.isAssignableFrom(value.getClass())) {
                String message = String.format("Expected key type is '%s' but got '%s'", valueType.getSimpleName(), value.getClass().getSimpleName());
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, message, new Object[0]);
            }
            Object oldValue = map.put(key, value);
            if (oldValue == null) continue;
            String message = String.format("Map cannot have duplicate keys: %s has values (%s, %s)", key, oldValue, value);
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, message, new Object[0]);
        }
        return map;
    }

    public static MapConstructor getInstance(int size) {
        return new MapConstructor(size);
    }
}

