/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.nio.charset.StandardCharsets;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class StringTypeConstructor
extends VariableWidthTypeConstructor<String> {
    public static StringTypeConstructor getInstance(int i) {
        return new StringTypeConstructor(i);
    }

    private StringTypeConstructor(int size) {
        super(size);
    }

    @Override
    public String construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (!in.hasRemaining(this.getSize())) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct string: insufficient input data", new Object[0]);
        }
        int size = this.getSize() == 1 ? in.getUnsignedByte() : in.getInt();
        if (!in.hasRemaining(size)) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct string: insufficient input data", new Object[0]);
        }
        byte[] data = new byte[size];
        in.get(data);
        return new String(data, StandardCharsets.UTF_8);
    }
}

