/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_8_v0_10;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.AMQPInvalidClassException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.exchange.ExchangeImpl;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.ReplyTo;

public class MessageConverter_0_10_to_0_8
implements MessageConverter<MessageTransferMessage, AMQMessage> {
    private static final int BASIC_CLASS_ID = 60;

    public static BasicContentHeaderProperties convertContentHeaderProperties(MessageTransferMessage messageTransferMessage, VirtualHost vhost) {
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        Header header = messageTransferMessage.getHeader();
        DeliveryProperties deliveryProps = header.getDeliveryProperties();
        MessageProperties messageProps = header.getMessageProperties();
        if (deliveryProps != null) {
            if (deliveryProps.hasDeliveryMode()) {
                props.setDeliveryMode(deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT ? (byte)2 : 1);
            }
            if (deliveryProps.hasExpiration()) {
                props.setExpiration(deliveryProps.getExpiration());
            }
            if (deliveryProps.hasPriority()) {
                props.setPriority((byte)deliveryProps.getPriority().getValue());
            }
            if (deliveryProps.hasTimestamp()) {
                props.setTimestamp(deliveryProps.getTimestamp());
            }
        }
        if (messageProps != null) {
            if (messageProps.hasAppId()) {
                props.setAppId(new AMQShortString(messageProps.getAppId()));
            }
            if (messageProps.hasContentType()) {
                props.setContentType(messageProps.getContentType());
            }
            if (messageProps.hasCorrelationId()) {
                props.setCorrelationId(new AMQShortString(messageProps.getCorrelationId()));
            }
            if (messageProps.hasContentEncoding()) {
                props.setEncoding(messageProps.getContentEncoding());
            }
            if (messageProps.hasMessageId()) {
                props.setMessageId("ID:" + messageProps.getMessageId().toString());
            }
            if (messageProps.hasReplyTo()) {
                ExchangeImpl exchange;
                ReplyTo replyTo = messageProps.getReplyTo();
                String exchangeName = replyTo.getExchange();
                String routingKey = replyTo.getRoutingKey();
                if (exchangeName == null) {
                    exchangeName = "";
                }
                String exchangeClass = (exchange = vhost.getExchange(exchangeName)) == null ? "direct" : exchange.getTypeName();
                props.setReplyTo(exchangeClass + "://" + exchangeName + "//?routingkey='" + (routingKey == null ? "" : routingKey + "'"));
            }
            if (messageProps.hasUserId()) {
                props.setUserId(new AMQShortString(messageProps.getUserId()));
            }
            if (messageProps.hasApplicationHeaders()) {
                HashMap appHeaders = new HashMap(messageProps.getApplicationHeaders());
                if (messageProps.getApplicationHeaders().containsKey("x-jms-type")) {
                    props.setType(String.valueOf(appHeaders.remove("x-jms-type")));
                }
                FieldTable ft = new FieldTable();
                for (Map.Entry entry : appHeaders.entrySet()) {
                    try {
                        ft.put(AMQShortString.validValueOf(entry.getKey()), entry.getValue());
                    }
                    catch (AMQPInvalidClassException e) {}
                }
                props.setHeaders(ft);
            }
        }
        return props;
    }

    public Class<MessageTransferMessage> getInputClass() {
        return MessageTransferMessage.class;
    }

    public Class<AMQMessage> getOutputClass() {
        return AMQMessage.class;
    }

    public AMQMessage convert(MessageTransferMessage message, VirtualHost vhost) {
        return new AMQMessage(this.convertToStoredMessage(message, vhost));
    }

    private StoredMessage<MessageMetaData> convertToStoredMessage(final MessageTransferMessage message, VirtualHost vhost) {
        final MessageMetaData metaData = this.convertMetaData(message, vhost);
        return new StoredMessage<MessageMetaData>(){

            public MessageMetaData getMetaData() {
                return metaData;
            }

            public long getMessageNumber() {
                return message.getMessageNumber();
            }

            public void addContent(int offsetInMessage, ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            public int getContent(int offsetInMessage, ByteBuffer dst) {
                return message.getContent(dst, offsetInMessage);
            }

            public ByteBuffer getContent(int offsetInMessage, int size) {
                return message.getContent(offsetInMessage, size);
            }

            public StoreFuture flushToStore() {
                return StoreFuture.IMMEDIATE_FUTURE;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private MessageMetaData convertMetaData(MessageTransferMessage message, VirtualHost vhost) {
        return new MessageMetaData(this.convertPublishBody(message), this.convertContentHeaderBody(message, vhost), message.getArrivalTime());
    }

    private ContentHeaderBody convertContentHeaderBody(MessageTransferMessage message, VirtualHost vhost) {
        BasicContentHeaderProperties props = MessageConverter_0_10_to_0_8.convertContentHeaderProperties(message, vhost);
        ContentHeaderBody chb = new ContentHeaderBody(props, 60);
        chb.setBodySize(message.getSize());
        return chb;
    }

    private MessagePublishInfo convertPublishBody(MessageTransferMessage message) {
        DeliveryProperties delvProps = message.getHeader().getDeliveryProperties();
        final AMQShortString exchangeName = delvProps == null || delvProps.getExchange() == null ? null : new AMQShortString(delvProps.getExchange());
        final AMQShortString routingKey = delvProps == null || delvProps.getRoutingKey() == null ? null : new AMQShortString(delvProps.getRoutingKey());
        final boolean immediate = delvProps != null && delvProps.getImmediate();
        final boolean mandatory = delvProps != null && !delvProps.getDiscardUnroutable();
        return new MessagePublishInfo(){

            public AMQShortString getExchange() {
                return exchangeName;
            }

            public void setExchange(AMQShortString exchange) {
                throw new UnsupportedOperationException();
            }

            public boolean isImmediate() {
                return immediate;
            }

            public boolean isMandatory() {
                return mandatory;
            }

            public AMQShortString getRoutingKey() {
                return routingKey;
            }
        };
    }

    public String getType() {
        return "v0-10 to v0-8";
    }
}

