/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.GenericAbstractJDBCMessageStore;
import org.apache.qpid.server.store.jdbc.JDBCDetails;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.apache.qpid.server.store.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJDBCMessageStore
extends GenericAbstractJDBCMessageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericJDBCMessageStore.class);
    private String _connectionURL;
    private ConnectionProvider _connectionProvider;
    private String _blobType;
    private String _varBinaryType;
    private String _bigIntType;
    private boolean _useBytesMethodsForBlob;

    @Override
    protected void doOpen(ConfiguredObject<?> parent) throws StoreException {
        JDBCSettings settings = (JDBCSettings)parent;
        this._connectionURL = settings.getConnectionUrl();
        JDBCDetails details = JDBCDetails.getDetailsForJdbcUrl(this._connectionURL, parent);
        if (!details.isKnownVendor() && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Do not recognize vendor from connection URL: " + this._connectionURL + " Using fallback settings " + details);
        }
        if (details.isOverridden() && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("One or more JDBC details were overridden from context.  Using settings : " + details);
        }
        this._blobType = details.getBlobType();
        this._varBinaryType = details.getVarBinaryType();
        this._useBytesMethodsForBlob = details.isUseBytesMethodsForBlob();
        this._bigIntType = details.getBigintType();
        this._connectionProvider = JdbcUtils.createConnectionProvider(parent, LOGGER);
    }

    @Override
    protected String getTablePrefix(ConfiguredObject<?> parent) {
        JDBCSettings settings = (JDBCSettings)parent;
        return settings.getTableNamePrefix();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._connectionProvider.getConnection();
    }

    @Override
    protected void doClose() {
        try {
            this._connectionProvider.close();
        }
        catch (SQLException e) {
            throw new StoreException("Unable to close connection provider ", (Throwable)e);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected String getSqlBlobType() {
        return this._blobType;
    }

    @Override
    protected String getSqlVarBinaryType(int size) {
        return String.format(this._varBinaryType, size);
    }

    @Override
    protected InputStream getBlobAsInputStream(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            return new ByteArrayInputStream(rs.getBytes(col));
        }
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBinaryStream();
    }

    @Override
    public String getSqlBigIntType() {
        return this._bigIntType;
    }

    public String getStoreLocation() {
        return this._connectionURL;
    }

    public File getStoreLocationAsFile() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelete(ConfiguredObject<?> parent) {
        if (this.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot delete the store as the store is still open");
        }
        ConnectionProvider connectionProvider = JdbcUtils.createConnectionProvider(parent, LOGGER);
        try {
            try (Connection conn = connectionProvider.getConnection();){
                conn.setAutoCommit(true);
                this.onDelete(conn);
            }
            catch (SQLException e) {
                this.getLogger().error("Exception while deleting store tables", (Throwable)e);
            }
        }
        finally {
            try {
                connectionProvider.close();
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to close connection provider ", (Throwable)e);
            }
        }
    }
}

