/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.logback.LogBackLogInclusionRule;

public class PrincipalLogEventFilter
extends Filter<ILoggingEvent>
implements LogBackLogInclusionRule {
    private final Principal _principal;

    public PrincipalLogEventFilter(Principal principal) {
        this._principal = principal;
    }

    public FilterReply decide(ILoggingEvent event) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && subject.getPrincipals().contains(this._principal)) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    @Override
    public Filter<ILoggingEvent> asFilter() {
        return this;
    }

    public String getName() {
        return "$" + this.getClass().getName();
    }
}

