/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.arithmetic;

import java.math.BigDecimal;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.arithmetic.AbstractArithmeticExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;

public class PlusExpression<T, R>
extends AbstractArithmeticExpression<T, R> {
    public PlusExpression(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        super(alias, left, right);
    }

    @Override
    public R apply(T value) {
        Object arg1 = this.evaluateChild(0, value);
        Object arg2 = this.evaluateChild(1, value);
        if (arg1 == null || arg2 == null) {
            return null;
        }
        if (arg1 instanceof String || arg2 instanceof String) {
            return (R)(arg1 + String.valueOf(arg2));
        }
        if (!(arg1 instanceof Number) || !(arg2 instanceof Number)) {
            throw QueryParsingException.of("Operator '%s' doesn't support arguments '%s' of type '%s' and '%s' of type '%s'", "+", arg1, StringUtils.getClassName(arg1), arg2, StringUtils.getClassName(arg2));
        }
        BigDecimal result = new BigDecimal(arg1.toString()).add(new BigDecimal(arg2.toString()));
        return NumberConverter.narrow(result);
    }
}

