/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.util.Map;
import org.apache.qpid.jms.provider.BalancedProviderFuture;
import org.apache.qpid.jms.provider.ConservativeProviderFuture;
import org.apache.qpid.jms.provider.ProgressiveProviderFuture;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderSynchronization;

public abstract class ProviderFutureFactory {
    public static final String PROVIDER_FUTURE_TYPE_KEY = "futureType";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String WINDOWS_OS_PREFIX = "Windows";
    private static final boolean IS_WINDOWS = ProviderFutureFactory.isOsNameMatch(OS_NAME, "Windows");
    private static final String CONSERVATIVE = "conservative";
    private static final String BALANCED = "balanced";
    private static final String PROGRESSIVE = "progressive";

    public static ProviderFutureFactory create(Map<String, String> providerOptions) {
        String futureTypeKey = providerOptions.remove(PROVIDER_FUTURE_TYPE_KEY);
        if (futureTypeKey == null || futureTypeKey.isEmpty()) {
            if (Runtime.getRuntime().availableProcessors() < 4) {
                return new ConservativeProviderFutureFactory();
            }
            if (ProviderFutureFactory.isWindows()) {
                return new BalancedProviderFutureFactory();
            }
            return new ProgressiveProviderFutureFactory();
        }
        switch (futureTypeKey.toLowerCase()) {
            case "conservative": {
                return new ConservativeProviderFutureFactory();
            }
            case "balanced": {
                return new BalancedProviderFutureFactory();
            }
            case "progressive": {
                return new ProgressiveProviderFutureFactory();
            }
        }
        throw new IllegalArgumentException("No ProviderFuture implementation with name " + futureTypeKey + " found");
    }

    public abstract ProviderFuture createFuture();

    public abstract ProviderFuture createFuture(ProviderSynchronization var1);

    public abstract ProviderFuture createUnfailableFuture();

    private static boolean isWindows() {
        return IS_WINDOWS;
    }

    private static boolean isOsNameMatch(String currentOSName, String osNamePrefix) {
        if (currentOSName == null || currentOSName.isEmpty()) {
            return false;
        }
        return currentOSName.startsWith(osNamePrefix);
    }

    private static class ProgressiveProviderFutureFactory
    extends ProviderFutureFactory {
        private ProgressiveProviderFutureFactory() {
        }

        @Override
        public ProviderFuture createFuture() {
            return new ProgressiveProviderFuture();
        }

        @Override
        public ProviderFuture createFuture(ProviderSynchronization synchronization) {
            return new ProgressiveProviderFuture(synchronization);
        }

        @Override
        public ProviderFuture createUnfailableFuture() {
            return new ProgressiveProviderFuture(){

                @Override
                public void onFailure(ProviderException t) {
                    this.onSuccess();
                }
            };
        }
    }

    private static class BalancedProviderFutureFactory
    extends ProviderFutureFactory {
        private BalancedProviderFutureFactory() {
        }

        @Override
        public ProviderFuture createFuture() {
            return new BalancedProviderFuture();
        }

        @Override
        public ProviderFuture createFuture(ProviderSynchronization synchronization) {
            return new BalancedProviderFuture(synchronization);
        }

        @Override
        public ProviderFuture createUnfailableFuture() {
            return new BalancedProviderFuture(){

                @Override
                public void onFailure(ProviderException t) {
                    this.onSuccess();
                }
            };
        }
    }

    private static class ConservativeProviderFutureFactory
    extends ProviderFutureFactory {
        private ConservativeProviderFutureFactory() {
        }

        @Override
        public ProviderFuture createFuture() {
            return new ConservativeProviderFuture();
        }

        @Override
        public ProviderFuture createFuture(ProviderSynchronization synchronization) {
            return new ConservativeProviderFuture(synchronization);
        }

        @Override
        public ProviderFuture createUnfailableFuture() {
            return new ConservativeProviderFuture(){

                @Override
                public void onFailure(ProviderException t) {
                    this.onSuccess();
                }
            };
        }
    }
}

