/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortHelper.class);
    public static final int START_PORT_NUMBER = 10000;
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    public static final int MIN_PORT_NUMBER = 1;
    public static final int MAX_PORT_NUMBER = 49151;
    private int _timeout = 5000;
    private final Set<Integer> _allocatedPorts = new HashSet<Integer>();
    private int _highestIssuedPort = -1;

    public int getNextAvailable(int fromPort) {
        if (fromPort < 1 || fromPort > 49151) {
            throw new IllegalArgumentException("Invalid start port: " + fromPort);
        }
        for (int i = fromPort; i <= 49151; ++i) {
            if (!this.isPortAvailable(i)) continue;
            this._allocatedPorts.add(i);
            this._highestIssuedPort = Math.max(this._highestIssuedPort, i);
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    public int getNextAvailable() {
        if (this._highestIssuedPort < 0) {
            return this.getNextAvailable(10000);
        }
        return this.getNextAvailable(this._highestIssuedPort + 1);
    }

    public void waitUntilAllocatedPortsAreFree() {
        this.waitUntilPortsAreFree(this._allocatedPorts);
    }

    public void waitUntilPortsAreFree(Set<Integer> ports) {
        LOGGER.debug("Checking if ports " + ports + " are free...");
        for (Integer port : ports) {
            if (port <= 0) continue;
            this.waitUntilPortIsFree(port);
        }
        LOGGER.debug("ports " + ports + " are free");
    }

    private void waitUntilPortIsFree(int port) {
        long startTime = System.currentTimeMillis();
        long deadline = startTime + (long)this._timeout;
        boolean alreadyFailed = false;
        while (true) {
            if (System.currentTimeMillis() > deadline) {
                throw new RuntimeException("Timed out after " + this._timeout + " ms waiting for port " + port + " to become available");
            }
            if (this.isPortAvailable(port)) {
                if (alreadyFailed) {
                    LOGGER.debug("port " + port + " is now available");
                }
                return;
            }
            alreadyFailed = true;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortAvailable(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(port));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("port " + port + " is not free");
            boolean bl = false;
            return bl;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't close port " + port + " that we created to check its availability", e);
                }
            }
        }
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }
}

