/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import ch.qos.logback.classic.LoggerContext;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidUnitTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpidUnitTestRunner.class);
    private final Class<?> _testClass;

    public QpidUnitTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this._testClass = klass;
    }

    public void run(RunNotifier notifier) {
        this.setClassQualifiedTestName(this._testClass.getName());
        try {
            super.run(notifier);
        }
        finally {
            this.setClassQualifiedTestName(null);
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        LOGGER.info("========================= executing test : {}", (Object)(this._testClass.getSimpleName() + "#" + method.getName()));
        this.setClassQualifiedTestName(this._testClass.getName() + "." + method.getName());
        LOGGER.info("========================= start executing test : {}", (Object)(this._testClass.getSimpleName() + "#" + method.getName()));
        try {
            super.runChild(method, notifier);
        }
        finally {
            LOGGER.info("========================= stop executing test : {} ", (Object)(this._testClass.getSimpleName() + "#" + method.getName()));
            this.setClassQualifiedTestName(this._testClass.getName());
            LOGGER.info("========================= cleaning up test environment for test : {}", (Object)(this._testClass.getSimpleName() + "#" + method.getName()));
        }
    }

    private void setClassQualifiedTestName(String name) {
        LoggerContext loggerContext = ((ch.qos.logback.classic.Logger)LOGGER).getLoggerContext();
        loggerContext.putProperty("classQualifiedTestName", name);
    }
}

