/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.util.HashMap;
import java.util.Map;
import org.junit.rules.ExternalResource;

public class SystemPropertySetter
extends ExternalResource {
    private Map<String, String> _storedProperties = new HashMap<String, String>();

    public synchronized void after() {
        this._storedProperties.forEach(this::setProperty);
    }

    public synchronized void setSystemProperty(String name, String value) {
        this._storedProperties.putIfAbsent(name, System.getProperty(name));
        this.setProperty(name, value);
    }

    private void setProperty(String name, String value) {
        if (value == null) {
            System.clearProperty(name);
        } else {
            System.setProperty(name, value);
        }
    }
}

