/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.qpid.test.utils.JvmVendor;
import org.apache.qpid.test.utils.PortHelper;
import org.apache.qpid.test.utils.QpidUnitTestRunner;
import org.apache.qpid.test.utils.SystemPropertySetter;
import org.apache.qpid.test.utils.VirtualHostNodeStoreType;
import org.junit.After;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

@RunWith(value=QpidUnitTestRunner.class)
public class UnitTestBase {
    public static final String TMP_FOLDER = System.getProperty("java.io.tmpdir");
    private static final String PROFILE_VIRTUALHOSTNODE_TYPE = "virtualhostnode.type";
    @Rule
    public final TestName _testName = new TestName();
    @Rule
    public final SystemPropertySetter _systemPropertySetter = new SystemPropertySetter();
    private final Set<Runnable> _tearDownRegistry = new LinkedHashSet<Runnable>();

    @After
    public void cleanupPostTest() {
        this._tearDownRegistry.forEach(Runnable::run);
    }

    public String getTestName() {
        return this._testName.getMethodName();
    }

    public void setTestSystemProperty(String property, String value) {
        this._systemPropertySetter.setSystemProperty(property, value);
    }

    public int findFreePort() {
        return new PortHelper().getNextAvailable();
    }

    public int getNextAvailable(int fromPort) {
        return new PortHelper().getNextAvailable(fromPort);
    }

    public void registerTearDown(Runnable runnable) {
        this._tearDownRegistry.add(runnable);
    }

    public static JvmVendor getJvmVendor() {
        return JvmVendor.getJvmVendor();
    }

    public VirtualHostNodeStoreType getVirtualHostNodeStoreType() {
        String type = System.getProperty(PROFILE_VIRTUALHOSTNODE_TYPE, VirtualHostNodeStoreType.MEMORY.name()).toUpperCase();
        return VirtualHostNodeStoreType.valueOf(type);
    }
}

