/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils.tls;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Comparator;
import org.apache.qpid.test.utils.tls.AlternativeName;
import org.apache.qpid.test.utils.tls.CertificateEntry;
import org.apache.qpid.test.utils.tls.KeyCertificatePair;
import org.apache.qpid.test.utils.tls.KeyStoreEntry;
import org.apache.qpid.test.utils.tls.PrivateKeyEntry;
import org.apache.qpid.test.utils.tls.TlsResourceBuilder;
import org.apache.qpid.test.utils.tls.TlsResourceHelper;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsResource
extends ExternalResource {
    private static final String PRIVATE_KEY_ALIAS = "private-key-alias";
    private static final String CERTIFICATE_ALIAS = "certificate-alias";
    private static final String SECRET = "secret";
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsResource.class);
    private Path _keystoreDirectory;
    private final String _privateKeyAlias;
    private final String _certificateAlias;
    private final String _secret;
    private final String _keyStoreType;

    public TlsResource() {
        this(PRIVATE_KEY_ALIAS, CERTIFICATE_ALIAS, SECRET, KeyStore.getDefaultType());
    }

    public TlsResource(String privateKeyAlias, String certificateAlias, String secret, String defaultType) {
        this._privateKeyAlias = privateKeyAlias;
        this._certificateAlias = certificateAlias;
        this._secret = secret;
        this._keyStoreType = defaultType;
    }

    public void before() throws Exception {
        Path targetDir = FileSystems.getDefault().getPath("target", new String[0]);
        this._keystoreDirectory = Files.createTempDirectory(targetDir, "test-tls-resources-", new FileAttribute[0]);
        LOGGER.debug("Test keystore directory is created : '{}'", (Object)this._keystoreDirectory);
    }

    public void after() {
        try {
            Files.walk(this._keystoreDirectory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(f -> {
                if (!f.delete()) {
                    LOGGER.warn("Could not delete file at {}", (Object)f.getAbsolutePath());
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("Failure to clean up test resources", (Throwable)e);
        }
    }

    public String getSecret() {
        return this._secret;
    }

    public char[] getSecretAsCharacters() {
        return this._secret == null ? new char[]{} : this._secret.toCharArray();
    }

    public String getPrivateKeyAlias() {
        return this._privateKeyAlias;
    }

    public String getCertificateAlias() {
        return this._certificateAlias;
    }

    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    public Path createKeyStore(KeyStoreEntry ... entries) throws Exception {
        return this.createKeyStore(this.getKeyStoreType(), entries);
    }

    public Path createKeyStore(String keyStoreType, KeyStoreEntry ... entries) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore ks = TlsResourceHelper.createKeyStore(keyStoreType, this.getSecretAsCharacters(), entries);
        return this.saveKeyStore(keyStoreType, ks);
    }

    public String createKeyStoreAsDataUrl(KeyStoreEntry ... entries) throws Exception {
        return TlsResourceHelper.createKeyStoreAsDataUrl(this.getKeyStoreType(), this.getSecretAsCharacters(), entries);
    }

    public Path createSelfSignedKeyStore(String dn) throws Exception {
        KeyCertificatePair keyCertPair = TlsResourceBuilder.createSelfSigned(dn, new AlternativeName[0]);
        return this.createKeyStore(new PrivateKeyEntry(this._privateKeyAlias, keyCertPair.getPrivateKey(), keyCertPair.getCertificate()));
    }

    public String createSelfSignedKeyStoreAsDataUrl(String dn) throws Exception {
        KeyCertificatePair keyCertPair = TlsResourceBuilder.createSelfSigned(dn, new AlternativeName[0]);
        return this.createKeyStoreAsDataUrl(new PrivateKeyEntry(this._privateKeyAlias, keyCertPair.getPrivateKey(), keyCertPair.getCertificate()));
    }

    public Path createSelfSignedTrustStore(String dn) throws Exception {
        KeyCertificatePair keyCertPair = TlsResourceBuilder.createSelfSigned(dn, new AlternativeName[0]);
        return this.createKeyStore(new CertificateEntry(this._certificateAlias, keyCertPair.getCertificate()));
    }

    public Path createSelfSignedTrustStore(String dn, Instant from, Instant to) throws Exception {
        KeyCertificatePair keyCertPair = TlsResourceBuilder.createSelfSigned(dn, from, to, new AlternativeName[0]);
        return this.createKeyStore(new CertificateEntry(this._certificateAlias, keyCertPair.getCertificate()));
    }

    public String createSelfSignedTrustStoreAsDataUrl(String dn) throws Exception {
        KeyCertificatePair keyCertPair = TlsResourceBuilder.createSelfSigned(dn, new AlternativeName[0]);
        return this.createKeyStoreAsDataUrl(new CertificateEntry(this._certificateAlias, keyCertPair.getCertificate()));
    }

    public Path createTrustStore(String dn, KeyCertificatePair ca) throws Exception {
        KeyCertificatePair keyCertPair = TlsResourceBuilder.createKeyPairAndCertificate(dn, ca, new AlternativeName[0]);
        String keyStoreType = this.getKeyStoreType();
        return this.createKeyStore(keyStoreType, new CertificateEntry(this._certificateAlias, keyCertPair.getCertificate()));
    }

    public Path createSelfSignedKeyStoreWithCertificate(String dn) throws Exception {
        KeyCertificatePair keyCertPair = TlsResourceBuilder.createSelfSigned(dn, new AlternativeName[0]);
        return this.createKeyStore(new PrivateKeyEntry(this._privateKeyAlias, keyCertPair.getPrivateKey(), keyCertPair.getCertificate()), new CertificateEntry(this._certificateAlias, keyCertPair.getCertificate()));
    }

    public Path createCrl(KeyCertificatePair caPair, X509Certificate ... certificate) throws CRLException {
        X509CRL crl = TlsResourceBuilder.createCertificateRevocationList(caPair, certificate);
        try {
            Path pkFile = this.createFile(".crl");
            try (FileOutputStream out = new FileOutputStream(pkFile.toFile());){
                TlsResourceHelper.saveCrlAsPem(out, crl);
            }
            return pkFile;
        }
        catch (IOException e) {
            throw new CRLException(e);
        }
    }

    public Path createCrlAsDer(KeyCertificatePair caPair, X509Certificate ... certificate) throws CRLException, IOException {
        X509CRL crl = TlsResourceBuilder.createCertificateRevocationList(caPair, certificate);
        return this.saveBytes(crl.getEncoded(), ".crl");
    }

    public String createCrlAsDataUrl(KeyCertificatePair caPair, X509Certificate ... certificate) throws CRLException {
        X509CRL crl = TlsResourceBuilder.createCertificateRevocationList(caPair, certificate);
        return TlsResourceHelper.getDataUrlForBytes(crl.getEncoded());
    }

    public Path savePrivateKeyAsPem(PrivateKey privateKey) throws IOException {
        Path pkFile = this.createFile(".pk.pem");
        try (FileOutputStream out = new FileOutputStream(pkFile.toFile());){
            TlsResourceHelper.savePrivateKeyAsPem(out, privateKey);
        }
        return pkFile;
    }

    public Path saveCertificateAsPem(X509Certificate ... certificate) throws IOException, CertificateEncodingException {
        Path certificateFile = this.createFile(".cer.pem");
        try (FileOutputStream out = new FileOutputStream(certificateFile.toFile());){
            TlsResourceHelper.saveCertificateAsPem(out, certificate);
        }
        return certificateFile;
    }

    public Path savePrivateKeyAsDer(PrivateKey privateKey) throws IOException {
        return this.saveBytes(privateKey.getEncoded(), ".pk.der");
    }

    public Path saveCertificateAsDer(X509Certificate certificate) throws CertificateEncodingException, IOException {
        return this.saveBytes(certificate.getEncoded(), ".cer.der");
    }

    public Path createFile(String suffix) throws IOException {
        return Files.createTempFile(this._keystoreDirectory, "tls", suffix, new FileAttribute[0]);
    }

    private Path saveBytes(byte[] bytes, String extension) throws IOException {
        Path pkFile = this.createFile(extension);
        try (FileOutputStream out = new FileOutputStream(pkFile.toFile());){
            out.write(bytes);
        }
        return pkFile;
    }

    private Path saveKeyStore(String keyStoreType, KeyStore ks) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Path storeFile = this.createFile("." + keyStoreType);
        TlsResourceHelper.saveKeyStoreIntoFile(ks, this.getSecretAsCharacters(), storeFile.toFile());
        return storeFile;
    }
}

