/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.netcdf.MetadataReader;
import org.apache.sis.storage.netcdf.NetcdfStoreProvider;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.Metadata;

public class NetcdfStore
extends DataStore {
    private final Decoder decoder;
    private Metadata metadata;

    public NetcdfStore(StorageConnector storageConnector) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"storage", (Object)storageConnector);
        try {
            this.decoder = NetcdfStoreProvider.decoder(this.listeners, storageConnector);
        }
        catch (IOException iOException) {
            throw new DataStoreException((Throwable)iOException);
        }
    }

    public Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataReader metadataReader = new MetadataReader(this.decoder);
                this.metadata = metadataReader.read();
                if (this.metadata instanceof ModifiableMetadata) {
                    ((ModifiableMetadata)this.metadata).freeze();
                }
            }
            catch (IOException iOException) {
                throw new DataStoreException((Throwable)iOException);
            }
        }
        return this.metadata;
    }

    public void close() throws DataStoreException {
        this.metadata = null;
        try {
            this.decoder.close();
        }
        catch (IOException iOException) {
            throw new DataStoreException((Throwable)iOException);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '[' + this.decoder + ']';
    }
}

