/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractBundlePostMojo;

abstract class AbstractBundleDeployMojo
extends AbstractBundlePostMojo {
    @Parameter(required=true, property="obr")
    private String obr;

    AbstractBundleDeployMojo() {
    }

    protected abstract String getJarFileName() throws MojoExecutionException;

    protected abstract File fixBundleVersion(File var1) throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        File jarFile = new File(this.getJarFileName());
        String bundleName = this.getBundleSymbolicName(jarFile);
        if (bundleName == null) {
            this.getLog().info((CharSequence)(jarFile + " is not an OSGi Bundle, not uploading"));
            return;
        }
        jarFile = this.fixBundleVersion(jarFile);
        this.getLog().info((CharSequence)("Deploying Bundle " + bundleName + "(" + jarFile + ") to " + this.obr));
        this.post(this.obr, jarFile);
    }

    private void post(String targetURL, File file) throws MojoExecutionException {
        PostMethod filePost = new PostMethod(targetURL);
        try {
            Part[] parts = new Part[]{new FilePart(file.getName(), (PartSource)new FilePartSource(file.getName(), file)), new StringPart("_noredir_", "_noredir_")};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            int status = client.executeMethod((HttpMethod)filePost);
            if (status == 200) {
                this.getLog().info((CharSequence)"Bundle deployed");
            } else {
                String msg = "Deployment failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Deployment on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected File changeVersion(File file, String oldVersion, String newVersion) throws MojoExecutionException {
        File file2;
        String fileName = file.getName();
        int pos = fileName.indexOf(oldVersion);
        fileName = fileName.substring(0, pos) + newVersion + fileName.substring(pos + oldVersion.length());
        JarInputStream jis = null;
        FileOutputStream out = null;
        try {
            JarFile sourceJar = new JarFile(file);
            Manifest manifest = sourceJar.getManifest();
            manifest.getMainAttributes().putValue("Bundle-Version", newVersion);
            jis = new JarInputStream(new FileInputStream(file));
            File destJar = new File(file.getParentFile(), fileName);
            out = new FileOutputStream(destJar);
            JarOutputStream jos = new JarOutputStream((OutputStream)out, manifest);
            jos.setMethod(8);
            jos.setLevel(9);
            JarEntry entryIn = jis.getNextJarEntry();
            while (entryIn != null) {
                JarEntry entryOut = new JarEntry(entryIn.getName());
                entryOut.setTime(entryIn.getTime());
                entryOut.setComment(entryIn.getComment());
                jos.putNextEntry(entryOut);
                if (!entryIn.isDirectory()) {
                    IOUtils.copy((InputStream)jis, (OutputStream)jos);
                }
                jos.closeEntry();
                jis.closeEntry();
                entryIn = jis.getNextJarEntry();
            }
            jos.close();
            file2 = destJar;
        }
        catch (IOException ioe) {
            try {
                throw new MojoExecutionException("Unable to update version in jar file.", (Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jis);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)jis);
        IOUtils.closeQuietly((OutputStream)out);
        return file2;
    }
}

