/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.maven.bundlesupport.AbstractBundlePostMojo;
import org.apache.sling.maven.bundlesupport.IntermediateUrisExtractor;
import org.apache.sling.maven.bundlesupport.MkColMethod;

abstract class AbstractBundleInstallMojo
extends AbstractBundlePostMojo {
    private static final String HEADER_INITIAL_CONTENT = "Sling-Initial-Content";
    private static final String FS_FACTORY = "org.apache.sling.fsprovider.internal.FsResourceProvider";
    protected static final String JSON_MIME_TYPE = "application/json";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    @Parameter(property="sling.url", defaultValue="http://localhost:8080/system/console", required=true)
    protected String slingUrl;
    @Parameter(property="sling.urlSuffix")
    protected String slingUrlSuffix;
    @Parameter(property="sling.usePut", defaultValue="false")
    protected boolean usePut;
    @Parameter(property="sling.deploy.method", required=false)
    protected BundleDeploymentMethod deploymentMethod;
    @Parameter(property="sling.mimeType", defaultValue="application/java-archive", required=true)
    protected String mimeType;
    @Parameter(property="sling.user", defaultValue="admin", required=true)
    private String user;
    @Parameter(property="sling.password", defaultValue="admin", required=true)
    private String password;
    @Parameter(property="sling.bundle.startlevel", defaultValue="20", required=true)
    private String bundleStartLevel;
    @Parameter(property="sling.bundle.start", defaultValue="true", required=true)
    private boolean bundleStart;
    @Parameter(property="sling.refreshPackages", defaultValue="true", required=true)
    private boolean refreshPackages;
    @Parameter(property="sling.mountByFS", defaultValue="false", required=true)
    private boolean mountByFS;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    protected abstract String getBundleFileName() throws MojoExecutionException;

    protected String getTargetURL() {
        String targetURL = this.slingUrl;
        if (this.slingUrlSuffix != null) {
            targetURL = targetURL + this.slingUrlSuffix;
        }
        return targetURL;
    }

    protected String getURLWithFilename(String targetURL, String fileName) {
        return targetURL + (targetURL.endsWith("/") ? "" : "/") + fileName;
    }

    public void execute() throws MojoExecutionException {
        String bundleFileName = this.getBundleFileName();
        File bundleFile = new File(bundleFileName);
        if (!bundleFile.exists()) {
            this.getLog().info((CharSequence)(bundleFile + " does not exist, no uploading"));
            return;
        }
        String bundleName = this.getBundleSymbolicName(bundleFile);
        if (bundleName == null) {
            this.getLog().info((CharSequence)(bundleFile + " is not an OSGi Bundle, not uploading"));
            return;
        }
        String targetURL = this.getTargetURL();
        BundleDeploymentMethod deploymentMethod = this.getDeploymentMethod();
        this.getLog().info((CharSequence)("Installing Bundle " + bundleName + "(" + bundleFile + ") to " + targetURL + " via " + (Object)((Object)deploymentMethod)));
        switch (deploymentMethod) {
            case SlingPostServlet: {
                this.postToSling(targetURL, bundleFile);
                break;
            }
            case WebConsole: {
                this.postToFelix(targetURL, bundleFile);
                break;
            }
            case WebDAV: {
                this.putViaWebDav(targetURL, bundleFile);
                break;
            }
            default: {
                throw new MojoExecutionException("Unrecognized BundleDeployMethod " + (Object)((Object)deploymentMethod));
            }
        }
        if (this.mountByFS) {
            this.configure(targetURL, bundleFile);
        }
    }

    protected BundleDeploymentMethod getDeploymentMethod() throws MojoExecutionException {
        if (this.deploymentMethod == null) {
            if (this.usePut) {
                this.getLog().warn((CharSequence)"Using deprecated configuration parameter 'usePut=true', please instead use the new parameter 'deploymentMethod=WebDAV'!");
                return BundleDeploymentMethod.WebDAV;
            }
            return BundleDeploymentMethod.WebConsole;
        }
        return this.deploymentMethod;
    }

    protected void throwWebConsoleTooOldException() throws MojoExecutionException {
        throw new MojoExecutionException("The Apache Felix Web Console is too old to mount the initial content through file system provider configs. Either upgrade the web console or disable this feature.");
    }

    protected HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        client.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.user, this.password);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        return client;
    }

    protected void postToFelix(String targetURL, File file) throws MojoExecutionException {
        PostMethod filePost = new PostMethod(targetURL + "/install");
        try {
            filePost.setRequestHeader("referer", "about:blank");
            ArrayList<Object> partList = new ArrayList<Object>();
            partList.add(new StringPart("action", "install"));
            partList.add(new StringPart("_noredir_", "_noredir_"));
            partList.add(new FilePart("bundlefile", (PartSource)new FilePartSource(file.getName(), file)));
            partList.add(new StringPart("bundlestartlevel", this.bundleStartLevel));
            if (this.bundleStart) {
                partList.add(new StringPart("bundlestart", "start"));
            }
            if (this.refreshPackages) {
                partList.add(new StringPart("refreshPackages", "true"));
            }
            Part[] parts = partList.toArray(new Part[partList.size()]);
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status == 200) {
                this.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected void postToSling(String targetURL, File file) throws MojoExecutionException {
        if (targetURL.endsWith("/")) {
            targetURL = targetURL.substring(0, targetURL.length() - 1);
        }
        PostMethod filePost = new PostMethod(targetURL);
        try {
            Part[] parts = new Part[]{new FilePart("*", (PartSource)new FilePartSource(file.getName(), file), this.mimeType, null), new StringPart("*@TypeHint", "nt:file")};
            filePost.setRequestHeader("Accept", JSON_MIME_TYPE);
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status == 200 || status == 201) {
                this.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected void putViaWebDav(String targetURL, File file) throws MojoExecutionException {
        boolean success = false;
        try {
            int status = this.performPut(targetURL, file);
            if (status >= 200 && status < 300) {
                success = true;
            } else if (status == 409) {
                this.getLog().debug((CharSequence)"Bundle not installed due missing parent folders. Attempting to create parent structure.");
                this.createIntermediaryPaths(targetURL);
                this.getLog().debug((CharSequence)"Re-attempting bundle install after creating parent folders.");
                status = this.performPut(targetURL, file);
                if (status >= 200 && status < 300) {
                    success = true;
                }
            }
            if (!success) {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performPut(String targetURL, File file) throws HttpException, IOException {
        PutMethod filePut = new PutMethod(this.getURLWithFilename(targetURL, file.getName()));
        try {
            filePut.setRequestEntity((RequestEntity)new FileRequestEntity(file, this.mimeType));
            int n = this.getHttpClient().executeMethod((HttpMethod)filePut);
            return n;
        }
        finally {
            filePut.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performHead(String uri) throws HttpException, IOException {
        HeadMethod head = new HeadMethod(uri);
        try {
            int n = this.getHttpClient().executeMethod((HttpMethod)head);
            return n;
        }
        finally {
            head.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performMkCol(String uri) throws IOException {
        MkColMethod mkCol = new MkColMethod(uri);
        try {
            int n = this.getHttpClient().executeMethod((HttpMethod)mkCol);
            return n;
        }
        finally {
            mkCol.releaseConnection();
        }
    }

    private void createIntermediaryPaths(String targetURL) throws HttpException, IOException, MojoExecutionException {
        List<String> intermediateUris = IntermediateUrisExtractor.extractIntermediateUris(targetURL);
        String existingIntermediateUri = null;
        for (String intermediateUri : intermediateUris) {
            int result = this.performHead(intermediateUri);
            if (result == 200) {
                existingIntermediateUri = intermediateUri;
                break;
            }
            if (result == 404) continue;
            throw new MojoExecutionException("Failed getting intermediate path at " + intermediateUri + "." + " Reason: " + HttpStatus.getStatusText((int)result));
        }
        if (existingIntermediateUri == null) {
            throw new MojoExecutionException("Could not find any intermediate path up until the root of " + targetURL + ".");
        }
        int startOfInexistingIntermediateUri = intermediateUris.indexOf(existingIntermediateUri);
        if (startOfInexistingIntermediateUri == -1) {
            throw new IllegalStateException("Could not find intermediate uri " + existingIntermediateUri + " in the list");
        }
        for (int index = startOfInexistingIntermediateUri - 1; index >= 0; --index) {
            String intermediateUri = intermediateUris.get(index);
            int result = this.performMkCol(intermediateUri);
            if (result != 201 && result != 200) {
                throw new MojoExecutionException("Failed creating intermediate path at '" + intermediateUri + "'." + " Reason: " + HttpStatus.getStatusText((int)result));
            }
            this.getLog().debug((CharSequence)("Intermediate path at " + intermediateUri + " successfully created"));
        }
    }

    protected void configure(String targetURL, File file) throws MojoExecutionException {
        ManifestHeader.Entry[] entries;
        ManifestHeader header = null;
        try {
            Manifest mf = this.getManifest(file);
            String value = mf.getMainAttributes().getValue(HEADER_INITIAL_CONTENT);
            if (value == null) {
                this.getLog().debug((CharSequence)"Bundle has no initial content - no file system provider config created.");
                return;
            }
            header = ManifestHeader.parse((String)value);
            if (header == null || header.getEntries().length == 0) {
                this.getLog().warn((CharSequence)("Unable to parse header or header is empty: " + value));
                return;
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to read manifest from file " + file, (Exception)ioe);
        }
        HttpClient client = this.getHttpClient();
        this.getLog().info((CharSequence)"Trying to configure file system provider...");
        List resources = this.project.getResources();
        if (resources == null || resources.size() == 0) {
            throw new MojoExecutionException("No resources configured for this project.");
        }
        Map oldConfigs = this.getCurrentFileProviderConfigs(targetURL, client);
        for (ManifestHeader.Entry entry : entries = header.getEntries()) {
            String ignoreValue;
            String path = entry.getValue();
            if (path != null && !path.endsWith("/")) {
                path = path + "/";
            }
            if ((ignoreValue = entry.getDirectiveValue("maven:mount")) != null && ignoreValue.equalsIgnoreCase("false")) {
                this.getLog().debug((CharSequence)("Ignoring " + path));
                continue;
            }
            String installPath = entry.getDirectiveValue("path");
            if (installPath == null) {
                installPath = "/";
            }
            File dir = null;
            Iterator i = resources.iterator();
            while (dir == null && i.hasNext()) {
                Resource rsrc = (Resource)i.next();
                String child = path;
                String targetPath = rsrc.getTargetPath();
                if (targetPath != null && !targetPath.endsWith("/")) {
                    targetPath = targetPath + "/";
                }
                if (targetPath != null && path.startsWith(targetPath)) {
                    child = child.substring(targetPath.length());
                }
                if ((dir = new File(rsrc.getDirectory(), child)).exists()) continue;
                dir = null;
            }
            if (dir == null) {
                throw new MojoExecutionException("No resource entry found containing " + path);
            }
            if ("/".equals(installPath)) {
                throw new MojoExecutionException("Mapping to root path not supported by fs provider at the moment. Please adapt your initial content configuration.");
            }
            this.getLog().info((CharSequence)("Mapping " + dir + " to " + installPath));
            boolean found = false;
            Iterator entryIterator = oldConfigs.entrySet().iterator();
            while (!found && entryIterator.hasNext()) {
                Map.Entry current = entryIterator.next();
                String[] value = (String[])current.getValue();
                this.getLog().debug((CharSequence)("Comparing " + dir.getAbsolutePath() + " with " + value[0] + " (" + value[1] + ")"));
                if (!dir.getAbsolutePath().equals(value[0])) continue;
                if (installPath.equals(value[1])) {
                    this.getLog().debug((CharSequence)("Using existing configuration for " + dir + " and " + installPath));
                    found = true;
                } else {
                    this.getLog().debug((CharSequence)("Removing old configuration for " + value[0] + " and " + value[1]));
                    this.removeConfiguration(client, targetURL, current.getKey().toString());
                }
                entryIterator.remove();
            }
            if (found) continue;
            this.getLog().debug((CharSequence)("Adding new configuration for " + dir + " and " + installPath));
            this.addConfiguration(client, targetURL, dir.getAbsolutePath(), installPath);
        }
        for (Map.Entry current : oldConfigs.entrySet()) {
            String[] value = (String[])current.getValue();
            this.getLog().debug((CharSequence)("Removing old configuration for " + value[0] + " and " + value[1]));
            this.removeConfiguration(client, targetURL, current.getKey().toString());
        }
    }

    protected void removeConfiguration(HttpClient client, String targetURL, String pid) throws MojoExecutionException {
        String postUrl = targetURL + "/configMgr/" + pid;
        PostMethod post = new PostMethod(postUrl);
        post.addParameter("apply", "true");
        post.addParameter("delete", "true");
        try {
            int status = client.executeMethod((HttpMethod)post);
            if (status == 302 || status == 200) {
                this.getLog().debug((CharSequence)"Configuration removed.");
            } else {
                this.getLog().error((CharSequence)("Removing configuration failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (HttpException ex) {
            throw new MojoExecutionException("Removing configuration at " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Removing configuration at " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    protected void addConfiguration(HttpClient client, String targetURL, String dir, String path) throws MojoExecutionException {
        String postUrl = targetURL + "/configMgr/" + FS_FACTORY;
        PostMethod post = new PostMethod(postUrl);
        post.addParameter("apply", "true");
        post.addParameter("factoryPid", FS_FACTORY);
        post.addParameter("pid", "[Temporary PID replaced by real PID upon save]");
        post.addParameter("provider.file", dir);
        post.addParameter("provider.roots", path);
        post.addParameter("propertylist", "provider.roots,provider.file");
        try {
            int status = client.executeMethod((HttpMethod)post);
            if (status == 302 || status == 200) {
                this.getLog().info((CharSequence)"Configuration created.");
            } else {
                this.getLog().error((CharSequence)("Configuration failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (HttpException ex) {
            throw new MojoExecutionException("Configuration on " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Configuration on " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    protected Map getCurrentFileProviderConfigs(String targetURL, HttpClient client) throws MojoExecutionException {
        HashMap<String, String[]> result;
        block11: {
            this.getLog().debug((CharSequence)"Getting current file provider configurations.");
            result = new HashMap<String, String[]>();
            String getUrl = targetURL + "/configMgr/(service.factoryPid=" + FS_FACTORY + ").json";
            GetMethod get = new GetMethod(getUrl);
            try {
                int status = client.executeMethod((HttpMethod)get);
                if (status != 200) break block11;
                String contentType = get.getResponseHeader(HEADER_CONTENT_TYPE).getValue();
                int pos = contentType.indexOf(59);
                if (pos != -1) {
                    contentType = contentType.substring(0, pos);
                }
                if (!JSON_MIME_TYPE.equals(contentType)) {
                    this.getLog().debug((CharSequence)("Response type from web console is not JSON, but " + contentType));
                    this.throwWebConsoleTooOldException();
                }
                String jsonText = get.getResponseBodyAsString();
                try {
                    JSONArray array = new JSONArray(jsonText);
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject obj = array.getJSONObject(i);
                        String pid = obj.getString("pid");
                        JSONObject properties = obj.getJSONObject("properties");
                        String path = properties.getJSONObject("provider.file").getString("value");
                        String roots = properties.getJSONObject("provider.roots").getString("value");
                        if (path == null || !path.startsWith(this.project.getBasedir().getAbsolutePath())) continue;
                        this.getLog().debug((CharSequence)("Found configuration with pid: " + pid + ", path: " + path + ", roots: " + roots));
                        result.put(pid, new String[]{path, roots});
                    }
                }
                catch (JSONException ex) {
                    throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
                }
            }
            catch (HttpException ex) {
                throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
            }
            finally {
                get.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getManifest(File bundleFile) throws IOException {
        JarFile file = null;
        try {
            file = new JarFile(bundleFile);
            Manifest manifest = file.getManifest();
            return manifest;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected String checkWebConsoleVersion(String targetUrl) {
        this.getLog().debug((CharSequence)"Checking web console version....");
        String bundleUrl = targetUrl + "/bundles/org.apache.felix.webconsole.json";
        HttpClient client = this.getHttpClient();
        GetMethod gm = new GetMethod(bundleUrl);
        try {
            int status = client.executeMethod((HttpMethod)gm);
            if (status == 200) {
                if (gm.getResponseContentLength() == 0L) {
                    this.getLog().debug((CharSequence)"Response has zero length. Assuming older version of web console.");
                    return null;
                }
                String jsonText = gm.getResponseBodyAsString();
                try {
                    JSONObject obj = new JSONObject(jsonText);
                    JSONArray props = obj.getJSONArray("props");
                    for (int i = 0; i < props.length(); ++i) {
                        JSONObject property = props.getJSONObject(i);
                        if (!"Version".equals(property.get("key"))) continue;
                        String version = property.getString("value");
                        this.getLog().debug((CharSequence)("Found web console version " + version));
                        return version;
                    }
                    this.getLog().debug((CharSequence)"Version property not found in response. Assuming older version.");
                    return null;
                }
                catch (JSONException ex) {
                    this.getLog().debug((CharSequence)("Converting response to JSON failed. Assuming older version: " + ex.getMessage()));
                    return null;
                }
            }
            this.getLog().debug((CharSequence)("Status code from web console: " + status));
        }
        catch (HttpException e) {
            this.getLog().debug((CharSequence)("HttpException: " + e.getMessage()));
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("IOException: " + e.getMessage()));
        }
        this.getLog().debug((CharSequence)"Unknown version.");
        return null;
    }

    static enum BundleDeploymentMethod {
        WebConsole,
        WebDAV,
        SlingPostServlet;

    }
}

