/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractBundlePostMojo
extends AbstractMojo {
    @Parameter(property="sling.failOnError", defaultValue="true", required=true)
    protected boolean failOnError;

    AbstractBundlePostMojo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getBundleSymbolicName(File jarFile) {
        if (!jarFile.exists()) {
            return null;
        }
        JarFile jaf = null;
        try {
            jaf = new JarFile(jarFile);
            Manifest manif = jaf.getManifest();
            if (manif == null) {
                this.getLog().debug((CharSequence)("getBundleSymbolicName: Missing manifest in " + jarFile));
                String string = null;
                return string;
            }
            String symbName = manif.getMainAttributes().getValue("Bundle-SymbolicName");
            if (symbName == null) {
                this.getLog().debug((CharSequence)("getBundleSymbolicName: No Bundle-SymbolicName in " + jarFile));
                String string = null;
                return string;
            }
            String string = symbName;
            return string;
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)("getBundleSymbolicName: Problem checking " + jarFile), (Throwable)ioe);
            return null;
        }
        finally {
            if (jaf != null) {
                try {
                    jaf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

