/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractBundleInstallMojo;

@Mojo(name="uninstall")
public class BundleUninstallMojo
extends AbstractBundleInstallMojo {
    @Parameter(property="sling.file", defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    private String bundleFileName;

    @Override
    protected String getBundleFileName() {
        return this.bundleFileName;
    }

    @Override
    public void execute() throws MojoExecutionException {
        File bundleFile = new File(this.bundleFileName);
        String bundleName = this.getBundleSymbolicName(bundleFile);
        if (bundleName == null) {
            this.getLog().info((CharSequence)(bundleFile + " is not an OSGi Bundle, not uploading"));
            return;
        }
        String targetURL = this.getTargetURL();
        AbstractBundleInstallMojo.BundleDeploymentMethod deployMethod = this.getDeploymentMethod();
        this.getLog().info((CharSequence)("Unistalling Bundle " + bundleName + " from " + targetURL + " via " + (Object)((Object)deployMethod)));
        this.configure(targetURL, bundleFile);
        switch (deployMethod) {
            case SlingPostServlet: {
                this.postToSling(targetURL, bundleFile);
                break;
            }
            case WebConsole: {
                this.postToFelix(targetURL, bundleName);
                break;
            }
            case WebDAV: {
                this.deleteViaWebDav(targetURL, bundleFile);
                break;
            }
            default: {
                throw new MojoExecutionException("Unrecognized BundleDeployMethod " + (Object)((Object)deployMethod));
            }
        }
    }

    protected void deleteViaWebDav(String targetURL, File file) throws MojoExecutionException {
        DeleteMethod delete = new DeleteMethod(this.getURLWithFilename(targetURL, file.getName()));
        try {
            int status = this.getHttpClient().executeMethod((HttpMethod)delete);
            if (status >= 200 && status < 300) {
                this.getLog().info((CharSequence)"Bundle uninstalled");
            } else {
                this.getLog().error((CharSequence)("Uninstall failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Uninstall from " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            delete.releaseConnection();
        }
    }

    @Override
    protected void postToSling(String targetURL, File file) throws MojoExecutionException {
        PostMethod post = new PostMethod(this.getURLWithFilename(targetURL, file.getName()));
        try {
            Part[] parts = new Part[]{new StringPart(":operation", "delete")};
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            post.setRequestHeader("Accept", "application/json");
            int status = this.getHttpClient().executeMethod((HttpMethod)post);
            if (status == 200) {
                this.getLog().info((CharSequence)"Bundle uninstalled");
            } else {
                this.getLog().error((CharSequence)("Uninstall failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Uninstall from " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    protected void postToFelix(String targetURL, String symbolicName) throws MojoExecutionException {
        PostMethod post = new PostMethod(targetURL + "/bundles/" + symbolicName);
        post.addParameter("action", "uninstall");
        try {
            int status = this.getHttpClient().executeMethod((HttpMethod)post);
            if (status == 200) {
                this.getLog().info((CharSequence)"Bundle uninstalled");
            } else {
                this.getLog().error((CharSequence)("Uninstall failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Uninstall from " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    protected void configure(String targetURL, File file) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Removing file system provider configurations...");
        HttpClient client = this.getHttpClient();
        Map oldConfigs = this.getCurrentFileProviderConfigs(targetURL, client);
        for (Map.Entry current : oldConfigs.entrySet()) {
            String[] value = (String[])current.getValue();
            this.getLog().debug((CharSequence)("Removing old configuration for " + value[0] + " and " + value[1]));
            this.removeConfiguration(client, targetURL, current.getKey().toString());
        }
    }
}

