/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.Prototype;
import org.apache.sling.feature.io.json.ManifestUtils;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

abstract class JSONWriterBase {
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));

    JSONWriterBase() {
    }

    protected final JsonGenerator newGenerator(Writer writer) {
        return this.generatorFactory.createGenerator(writer);
    }

    protected void writeBundles(JsonGenerator generator, Bundles bundles, Configurations allConfigs) {
        if (!bundles.isEmpty()) {
            generator.writeStartArray("bundles");
            for (Artifact artifact : bundles) {
                Configurations cfgs = new Configurations();
                for (Configuration cfg : allConfigs) {
                    String artifactProp = (String)cfg.getProperties().get(":configurator:feature:service.bundleLocation");
                    if (!artifact.getId().toMvnId().equals(artifactProp)) continue;
                    cfgs.add((Object)cfg);
                }
                Map md = artifact.getMetadata();
                if (md.isEmpty() && cfgs.isEmpty()) {
                    generator.write(artifact.getId().toMvnId());
                    continue;
                }
                generator.writeStartObject();
                generator.write("id", artifact.getId().toMvnId());
                Object runmodes = md.remove("runmodes");
                if (runmodes instanceof String) {
                    md.put("run-modes", (String)runmodes);
                }
                for (Map.Entry me : md.entrySet()) {
                    generator.write((String)me.getKey(), (String)me.getValue());
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected void writeConfigurations(JsonGenerator generator, Configurations cfgs) {
        if (cfgs.isEmpty()) {
            return;
        }
        generator.writeStartObject("configurations");
        for (Configuration cfg : cfgs) {
            generator.writeStartObject(cfg.getPid());
            Enumeration e = cfg.getProperties().keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (":configurator:feature:service.bundleLocation".equals(name)) continue;
                Object val = cfg.getProperties().get(name);
                String typePostFix = null;
                Object typeCheck = val.getClass().isArray() ? (Array.getLength(val) > 0 ? Array.get(val, 0) : null) : val;
                if (typeCheck instanceof Integer) {
                    typePostFix = ":Integer";
                } else if (typeCheck instanceof Byte) {
                    typePostFix = ":Byte";
                } else if (typeCheck instanceof Character) {
                    typePostFix = ":Character";
                } else if (typeCheck instanceof Float) {
                    typePostFix = ":Float";
                }
                if (val.getClass().isArray()) {
                    generator.writeStartArray(name);
                    for (int i = 0; i < Array.getLength(val); ++i) {
                        Object obj = Array.get(val, i);
                        if (typePostFix == null) {
                            if (obj instanceof String) {
                                generator.write((String)obj);
                                continue;
                            }
                            if (obj instanceof Boolean) {
                                generator.write(((Boolean)obj).booleanValue());
                                continue;
                            }
                            if (obj instanceof Long) {
                                generator.write(((Long)obj).longValue());
                                continue;
                            }
                            if (!(obj instanceof Double)) continue;
                            generator.write(((Double)obj).doubleValue());
                            continue;
                        }
                        generator.write(obj.toString());
                    }
                    generator.writeEnd();
                    continue;
                }
                if (typePostFix == null) {
                    if (val instanceof String) {
                        generator.write(name, (String)val);
                        continue;
                    }
                    if (val instanceof Boolean) {
                        generator.write(name, ((Boolean)val).booleanValue());
                        continue;
                    }
                    if (val instanceof Long) {
                        generator.write(name, ((Long)val).longValue());
                        continue;
                    }
                    if (!(val instanceof Double)) continue;
                    generator.write(name, ((Double)val).doubleValue());
                    continue;
                }
                generator.write(name + typePostFix, val.toString());
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected void writeVariables(JsonGenerator generator, Map<String, String> vars) {
        if (!vars.isEmpty()) {
            generator.writeStartObject("variables");
            for (Map.Entry<String, String> entry : vars.entrySet()) {
                String val = entry.getValue();
                if (val != null) {
                    generator.write(entry.getKey(), val);
                    continue;
                }
                generator.writeNull(entry.getKey());
            }
            generator.writeEnd();
        }
    }

    protected void writeFrameworkProperties(JsonGenerator generator, Map<String, String> props) {
        if (!props.isEmpty()) {
            generator.writeStartObject("framework-properties");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                generator.write(entry.getKey(), entry.getValue());
            }
            generator.writeEnd();
        }
    }

    protected void writeExtensions(JsonGenerator generator, List<Extension> extensions, Configurations allConfigs) {
        for (Extension ext : extensions) {
            String state;
            switch (ext.getState()) {
                case OPTIONAL: {
                    state = "false";
                    break;
                }
                case REQUIRED: {
                    state = "true";
                    break;
                }
                default: {
                    state = ext.getState().name();
                }
            }
            String key = ext.getName().concat(":").concat(ext.getType().name()).concat("|").concat(state);
            if (ext.getType() == ExtensionType.JSON) {
                generator.write(key, (JsonValue)ext.getJSONStructure());
                continue;
            }
            if (ext.getType() == ExtensionType.TEXT) {
                generator.writeStartArray(key);
                for (String line : ext.getText().split("\n")) {
                    generator.write(line);
                }
                generator.writeEnd();
                continue;
            }
            generator.writeStartArray(key);
            for (Artifact artifact : ext.getArtifacts()) {
                Configurations artifactCfgs = new Configurations();
                for (Configuration cfg : allConfigs) {
                    String artifactProp = (String)cfg.getProperties().get(":configurator:feature:service.bundleLocation");
                    if (!artifact.getId().toMvnId().equals(artifactProp)) continue;
                    artifactCfgs.add((Object)cfg);
                }
                if (artifact.getMetadata().isEmpty() && artifactCfgs.isEmpty()) {
                    generator.write(artifact.getId().toMvnId());
                    continue;
                }
                generator.writeStartObject();
                generator.write("id", artifact.getId().toMvnId());
                for (Map.Entry me : artifact.getMetadata().entrySet()) {
                    generator.write((String)me.getKey(), (String)me.getValue());
                }
                this.writeConfigurations(generator, artifactCfgs);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected void writeProperty(JsonGenerator generator, String key, String value) {
        if (value != null) {
            generator.write(key, value);
        }
    }

    protected <T> void writeList(JsonGenerator generator, String name, Collection<T> values) {
        if (!values.isEmpty()) {
            generator.writeStartArray(name);
            for (T value : values) {
                generator.write(value.toString());
            }
            generator.writeEnd();
        }
    }

    protected void writePrototype(JsonGenerator generator, Prototype inc) {
        if (inc == null) {
            return;
        }
        if (inc.getArtifactExtensionRemovals().isEmpty() && inc.getBundleRemovals().isEmpty() && inc.getConfigurationRemovals().isEmpty() && inc.getFrameworkPropertiesRemovals().isEmpty()) {
            generator.write("prototype", inc.getId().toMvnId());
        } else {
            generator.writeStartObject("prototype");
            this.writeProperty(generator, "id", inc.getId().toMvnId());
            generator.writeStartObject("removals");
            if (!inc.getArtifactExtensionRemovals().isEmpty() || inc.getExtensionRemovals().isEmpty()) {
                generator.writeStartArray("extensions");
                for (String string : inc.getExtensionRemovals()) {
                    generator.write(string);
                }
                for (Map.Entry entry : inc.getArtifactExtensionRemovals().entrySet()) {
                    generator.writeStartObject();
                    this.writeList(generator, (String)entry.getKey(), (Collection)entry.getValue());
                    generator.writeEnd();
                }
                generator.writeEnd();
            }
            this.writeList(generator, "configurations", inc.getConfigurationRemovals());
            this.writeList(generator, "bundles", inc.getBundleRemovals());
            this.writeList(generator, "framework-properties", inc.getFrameworkPropertiesRemovals());
            generator.writeEnd().writeEnd();
        }
    }

    protected void writeRequirements(JsonGenerator generator, List<MatchingRequirement> requirements) {
        if (requirements.isEmpty()) {
            return;
        }
        generator.writeStartArray("requirements");
        for (Requirement requirement : requirements) {
            generator.writeStartObject();
            this.writeProperty(generator, "namespace", requirement.getNamespace());
            if (!requirement.getAttributes().isEmpty()) {
                generator.writeStartObject("attributes");
                requirement.getAttributes().forEach((key, value) -> ManifestUtils.marshalAttribute(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            if (!requirement.getDirectives().isEmpty()) {
                generator.writeStartObject("directives");
                requirement.getDirectives().forEach((key, value) -> ManifestUtils.marshalDirective(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected void writeCapabilities(JsonGenerator generator, List<Capability> capabilities) {
        if (capabilities.isEmpty()) {
            return;
        }
        generator.writeStartArray("capabilities");
        for (Capability cap : capabilities) {
            generator.writeStartObject();
            this.writeProperty(generator, "namespace", cap.getNamespace());
            if (!cap.getAttributes().isEmpty()) {
                generator.writeStartObject("attributes");
                cap.getAttributes().forEach((key, value) -> ManifestUtils.marshalAttribute(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            if (!cap.getDirectives().isEmpty()) {
                generator.writeStartObject("directives");
                cap.getDirectives().forEach((key, value) -> ManifestUtils.marshalDirective(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }
}

